/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics5.jetty9;

import io.dropwizard.metrics5.Metric;
import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.RatioGauge;
import java.util.concurrent.BlockingQueue;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.thread.QueuedThreadPool;

public class InstrumentedQueuedThreadPool
extends QueuedThreadPool {
    private static final String NAME_UTILIZATION = "utilization";
    private static final String NAME_UTILIZATION_MAX = "utilization-max";
    private static final String NAME_SIZE = "size";
    private static final String NAME_JOBS = "jobs";
    private static final String NAME_JOBS_QUEUE_UTILIZATION = "jobs-queue-utilization";
    private final MetricRegistry metricRegistry;
    private String prefix;

    public InstrumentedQueuedThreadPool(@Name(value="registry") MetricRegistry registry) {
        this(registry, 200);
    }

    public InstrumentedQueuedThreadPool(@Name(value="registry") MetricRegistry registry, @Name(value="maxThreads") int maxThreads) {
        this(registry, maxThreads, 8);
    }

    public InstrumentedQueuedThreadPool(@Name(value="registry") MetricRegistry registry, @Name(value="maxThreads") int maxThreads, @Name(value="minThreads") int minThreads) {
        this(registry, maxThreads, minThreads, 60000);
    }

    public InstrumentedQueuedThreadPool(@Name(value="registry") MetricRegistry registry, @Name(value="maxThreads") int maxThreads, @Name(value="minThreads") int minThreads, @Name(value="idleTimeout") int idleTimeout) {
        this(registry, maxThreads, minThreads, idleTimeout, null);
    }

    public InstrumentedQueuedThreadPool(@Name(value="registry") MetricRegistry registry, @Name(value="maxThreads") int maxThreads, @Name(value="minThreads") int minThreads, @Name(value="idleTimeout") int idleTimeout, @Name(value="queue") BlockingQueue<Runnable> queue) {
        this(registry, maxThreads, minThreads, idleTimeout, queue, null);
    }

    public InstrumentedQueuedThreadPool(@Name(value="registry") MetricRegistry registry, @Name(value="maxThreads") int maxThreads, @Name(value="minThreads") int minThreads, @Name(value="idleTimeout") int idleTimeout, @Name(value="queue") BlockingQueue<Runnable> queue, @Name(value="prefix") String prefix) {
        super(maxThreads, minThreads, idleTimeout, queue);
        this.metricRegistry = registry;
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    protected void doStart() throws Exception {
        super.doStart();
        MetricName prefix = this.getMetricPrefix();
        this.metricRegistry.register(prefix.resolve(new String[]{NAME_UTILIZATION}), (Metric)new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)(InstrumentedQueuedThreadPool.this.getThreads() - InstrumentedQueuedThreadPool.this.getIdleThreads()), (double)InstrumentedQueuedThreadPool.this.getThreads());
            }
        });
        this.metricRegistry.register(prefix.resolve(new String[]{NAME_UTILIZATION_MAX}), (Metric)new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)(InstrumentedQueuedThreadPool.this.getThreads() - InstrumentedQueuedThreadPool.this.getIdleThreads()), (double)InstrumentedQueuedThreadPool.this.getMaxThreads());
            }
        });
        this.metricRegistry.registerGauge(prefix.resolve(new String[]{NAME_SIZE}), () -> ((InstrumentedQueuedThreadPool)this).getThreads());
        this.metricRegistry.registerGauge(prefix.resolve(new String[]{NAME_JOBS}), () -> this.getQueue().size());
        this.metricRegistry.register(prefix.resolve(new String[]{NAME_JOBS_QUEUE_UTILIZATION}), (Metric)new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                BlockingQueue queue = InstrumentedQueuedThreadPool.this.getQueue();
                return RatioGauge.Ratio.of((double)queue.size(), (double)(queue.size() + queue.remainingCapacity()));
            }
        });
    }

    protected void doStop() throws Exception {
        MetricName prefix = this.getMetricPrefix();
        this.metricRegistry.remove(prefix.resolve(new String[]{NAME_UTILIZATION}));
        this.metricRegistry.remove(prefix.resolve(new String[]{NAME_UTILIZATION_MAX}));
        this.metricRegistry.remove(prefix.resolve(new String[]{NAME_SIZE}));
        this.metricRegistry.remove(prefix.resolve(new String[]{NAME_JOBS}));
        this.metricRegistry.remove(prefix.resolve(new String[]{NAME_JOBS_QUEUE_UTILIZATION}));
        super.doStop();
    }

    private MetricName getMetricPrefix() {
        return this.prefix == null ? MetricRegistry.name(QueuedThreadPool.class, (String[])new String[]{this.getName()}) : MetricRegistry.name((String)this.prefix, (String[])new String[]{this.getName()});
    }
}

