/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics5.jetty9;

import io.dropwizard.metrics5.Counter;
import io.dropwizard.metrics5.Meter;
import io.dropwizard.metrics5.Metric;
import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.RatioGauge;
import io.dropwizard.metrics5.Timer;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.server.AsyncContextState;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;

public class InstrumentedHandler
extends HandlerWrapper {
    private final MetricRegistry metricRegistry;
    private String name;
    private final String prefix;
    private Timer requests;
    private Timer dispatches;
    private Counter activeRequests;
    private Counter activeDispatches;
    private Counter activeSuspended;
    private Meter asyncDispatches;
    private Meter asyncTimeouts;
    private Meter[] responses;
    private Timer getRequests;
    private Timer postRequests;
    private Timer headRequests;
    private Timer putRequests;
    private Timer deleteRequests;
    private Timer optionsRequests;
    private Timer traceRequests;
    private Timer connectRequests;
    private Timer moveRequests;
    private Timer otherRequests;
    private AsyncListener listener;

    public InstrumentedHandler(MetricRegistry registry) {
        this(registry, null);
    }

    public InstrumentedHandler(MetricRegistry registry, String prefix) {
        this.metricRegistry = registry;
        this.prefix = prefix;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected void doStart() throws Exception {
        super.doStart();
        MetricName prefix = this.prefix == null ? MetricRegistry.name(this.getHandler().getClass(), (String[])new String[]{this.name}) : MetricRegistry.name((String)this.prefix, (String[])new String[]{this.name});
        this.requests = this.metricRegistry.timer(prefix.resolve("requests"));
        this.dispatches = this.metricRegistry.timer(prefix.resolve("dispatches"));
        this.activeRequests = this.metricRegistry.counter(prefix.resolve("active-requests"));
        this.activeDispatches = this.metricRegistry.counter(prefix.resolve("active-dispatches"));
        this.activeSuspended = this.metricRegistry.counter(prefix.resolve("active-suspended"));
        this.asyncDispatches = this.metricRegistry.meter(prefix.resolve("async-dispatches"));
        this.asyncTimeouts = this.metricRegistry.meter(prefix.resolve("async-timeouts"));
        this.responses = new Meter[]{this.metricRegistry.meter(prefix.resolve("1xx-responses")), this.metricRegistry.meter(prefix.resolve("2xx-responses")), this.metricRegistry.meter(prefix.resolve("3xx-responses")), this.metricRegistry.meter(prefix.resolve("4xx-responses")), this.metricRegistry.meter(prefix.resolve("5xx-responses"))};
        this.getRequests = this.metricRegistry.timer(prefix.resolve("get-requests"));
        this.postRequests = this.metricRegistry.timer(prefix.resolve("post-requests"));
        this.headRequests = this.metricRegistry.timer(prefix.resolve("head-requests"));
        this.putRequests = this.metricRegistry.timer(prefix.resolve("put-requests"));
        this.deleteRequests = this.metricRegistry.timer(prefix.resolve("delete-requests"));
        this.optionsRequests = this.metricRegistry.timer(prefix.resolve("options-requests"));
        this.traceRequests = this.metricRegistry.timer(prefix.resolve("trace-requests"));
        this.connectRequests = this.metricRegistry.timer(prefix.resolve("connect-requests"));
        this.moveRequests = this.metricRegistry.timer(prefix.resolve("move-requests"));
        this.otherRequests = this.metricRegistry.timer(prefix.resolve("other-requests"));
        this.metricRegistry.register(prefix.resolve("percent-4xx-1m"), (Metric)new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)InstrumentedHandler.this.responses[3].getOneMinuteRate(), (double)InstrumentedHandler.this.requests.getOneMinuteRate());
            }
        });
        this.metricRegistry.register(prefix.resolve("percent-4xx-5m"), (Metric)new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)InstrumentedHandler.this.responses[3].getFiveMinuteRate(), (double)InstrumentedHandler.this.requests.getFiveMinuteRate());
            }
        });
        this.metricRegistry.register(prefix.resolve("percent-4xx-15m"), (Metric)new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)InstrumentedHandler.this.responses[3].getFifteenMinuteRate(), (double)InstrumentedHandler.this.requests.getFifteenMinuteRate());
            }
        });
        this.metricRegistry.register(prefix.resolve("percent-5xx-1m"), (Metric)new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)InstrumentedHandler.this.responses[4].getOneMinuteRate(), (double)InstrumentedHandler.this.requests.getOneMinuteRate());
            }
        });
        this.metricRegistry.register(prefix.resolve("percent-5xx-5m"), (Metric)new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)InstrumentedHandler.this.responses[4].getFiveMinuteRate(), (double)InstrumentedHandler.this.requests.getFiveMinuteRate());
            }
        });
        this.metricRegistry.register(prefix.resolve("percent-5xx-15m"), (Metric)new RatioGauge(){

            public RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)InstrumentedHandler.this.responses[4].getFifteenMinuteRate(), (double)InstrumentedHandler.this.requests.getFifteenMinuteRate());
            }
        });
        this.listener = new AsyncListener(){
            private long startTime;

            public void onTimeout(AsyncEvent event) throws IOException {
                InstrumentedHandler.this.asyncTimeouts.mark();
            }

            public void onStartAsync(AsyncEvent event) throws IOException {
                this.startTime = System.currentTimeMillis();
                event.getAsyncContext().addListener((AsyncListener)this);
            }

            public void onError(AsyncEvent event) throws IOException {
            }

            public void onComplete(AsyncEvent event) throws IOException {
                AsyncContextState state = (AsyncContextState)event.getAsyncContext();
                HttpServletRequest request = (HttpServletRequest)state.getRequest();
                HttpServletResponse response = (HttpServletResponse)state.getResponse();
                InstrumentedHandler.this.updateResponses(request, response, this.startTime, true);
                if (state.getHttpChannelState().getState() != HttpChannelState.State.DISPATCHED) {
                    InstrumentedHandler.this.activeSuspended.dec();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String path, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
        long start;
        this.activeDispatches.inc();
        HttpChannelState state = request.getHttpChannelState();
        if (state.isInitial()) {
            this.activeRequests.inc();
            start = request.getTimeStamp();
            state.addListener(this.listener);
        } else {
            start = System.currentTimeMillis();
            this.activeSuspended.dec();
            if (state.getState() == HttpChannelState.State.DISPATCHED) {
                this.asyncDispatches.mark();
            }
        }
        try {
            super.handle(path, request, httpRequest, httpResponse);
        }
        finally {
            long now = System.currentTimeMillis();
            long dispatched = now - start;
            this.activeDispatches.dec();
            this.dispatches.update(dispatched, TimeUnit.MILLISECONDS);
            if (state.isSuspended()) {
                this.activeSuspended.inc();
            } else if (state.isInitial()) {
                this.updateResponses(httpRequest, httpResponse, start, request.isHandled());
            }
        }
    }

    private Timer requestTimer(String method) {
        HttpMethod m = HttpMethod.fromString((String)method);
        if (m == null) {
            return this.otherRequests;
        }
        switch (m) {
            case GET: {
                return this.getRequests;
            }
            case POST: {
                return this.postRequests;
            }
            case PUT: {
                return this.putRequests;
            }
            case HEAD: {
                return this.headRequests;
            }
            case DELETE: {
                return this.deleteRequests;
            }
            case OPTIONS: {
                return this.optionsRequests;
            }
            case TRACE: {
                return this.traceRequests;
            }
            case CONNECT: {
                return this.connectRequests;
            }
            case MOVE: {
                return this.moveRequests;
            }
        }
        return this.otherRequests;
    }

    private void updateResponses(HttpServletRequest request, HttpServletResponse response, long start, boolean isHandled) {
        int responseStatus = isHandled ? response.getStatus() / 100 : 4;
        if (responseStatus >= 1 && responseStatus <= 5) {
            this.responses[responseStatus - 1].mark();
        }
        this.activeRequests.dec();
        long elapsedTime = System.currentTimeMillis() - start;
        this.requests.update(elapsedTime, TimeUnit.MILLISECONDS);
        this.requestTimer(request.getMethod()).update(elapsedTime, TimeUnit.MILLISECONDS);
    }
}

