/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics5.jvm;

import io.dropwizard.metrics5.Gauge;
import io.dropwizard.metrics5.Metric;
import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricSet;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class JvmAttributeGaugeSet
implements MetricSet {
    private final RuntimeMXBean runtime;

    public JvmAttributeGaugeSet() {
        this(ManagementFactory.getRuntimeMXBean());
    }

    public JvmAttributeGaugeSet(RuntimeMXBean runtime) {
        this.runtime = runtime;
    }

    public Map<MetricName, Metric> getMetrics() {
        HashMap<MetricName, Gauge> gauges = new HashMap<MetricName, Gauge>();
        gauges.put(MetricName.build((String[])new String[]{"name"}), this.runtime::getName);
        gauges.put(MetricName.build((String[])new String[]{"vendor"}), () -> String.format(Locale.US, "%s %s %s (%s)", this.runtime.getVmVendor(), this.runtime.getVmName(), this.runtime.getVmVersion(), this.runtime.getSpecVersion()));
        gauges.put(MetricName.build((String[])new String[]{"uptime"}), this.runtime::getUptime);
        return Collections.unmodifiableMap(gauges);
    }
}

