/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics5.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import io.dropwizard.metrics5.Meter;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.SharedMetricRegistries;

public class InstrumentedAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private final MetricRegistry registry;
    public static final String DEFAULT_REGISTRY = "logback-metrics";
    public static final String REGISTRY_PROPERTY_NAME = "metrics.logback.registry";
    private Meter all;
    private Meter trace;
    private Meter debug;
    private Meter info;
    private Meter warn;
    private Meter error;

    public InstrumentedAppender() {
        this(System.getProperty(REGISTRY_PROPERTY_NAME, DEFAULT_REGISTRY));
    }

    public InstrumentedAppender(String registryName) {
        this(SharedMetricRegistries.getOrCreate((String)registryName));
    }

    public InstrumentedAppender(MetricRegistry registry) {
        this.registry = registry;
        this.setName(Appender.class.getName());
    }

    public void start() {
        this.all = this.registry.meter(MetricRegistry.name((String)this.getName(), (String[])new String[]{"all"}));
        this.trace = this.registry.meter(MetricRegistry.name((String)this.getName(), (String[])new String[]{"trace"}));
        this.debug = this.registry.meter(MetricRegistry.name((String)this.getName(), (String[])new String[]{"debug"}));
        this.info = this.registry.meter(MetricRegistry.name((String)this.getName(), (String[])new String[]{"info"}));
        this.warn = this.registry.meter(MetricRegistry.name((String)this.getName(), (String[])new String[]{"warn"}));
        this.error = this.registry.meter(MetricRegistry.name((String)this.getName(), (String[])new String[]{"error"}));
        super.start();
    }

    protected void append(ILoggingEvent event) {
        this.all.mark();
        switch (event.getLevel().toInt()) {
            case 5000: {
                this.trace.mark();
                break;
            }
            case 10000: {
                this.debug.mark();
                break;
            }
            case 20000: {
                this.info.mark();
                break;
            }
            case 30000: {
                this.warn.mark();
                break;
            }
            case 40000: {
                this.error.mark();
                break;
            }
        }
    }
}

