/*
 * Decompiled with CFR 0.152.
 */
package io.easyspring.framework.common.snowflake;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Snowflake {
    private static final Logger log = LoggerFactory.getLogger(Snowflake.class);
    private static final long START_TIMESTAMP = 1543593600000L;
    private static final long WORKER_ID_BITS = 5L;
    private static final long DATA_CENTER_ID_BITS = 5L;
    private static final long MAX_WORKER_ID = 31L;
    private static final long MAX_DATA_CENTER_ID = 31L;
    private static final long SEQUENCE_BITS = 12L;
    private static final long WORKER_ID_SHIFT = 12L;
    private static final long DATA_CENTER_ID_SHIFT = 17L;
    private static final long TIMESTAMP_LEFT_SHIFT = 22L;
    private static final long SEQUENCE_MASK = 4095L;
    private long workerId;
    private long dataCenterId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;
    private static Snowflake instance = null;

    private Snowflake(long workerId, long dataCenterId) {
        log.info("[id \u751f\u6210\u5668] id \u751f\u6210\u5668\u521d\u59cb\u5316, \u673a\u5668 id: {}, \u6570\u636e\u4e2d\u5fc3 id: {}", (Object)workerId, (Object)dataCenterId);
        if (workerId > 31L || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", 31L));
        }
        if (dataCenterId > 31L || dataCenterId < 0L) {
            throw new IllegalArgumentException(String.format("dataCenter Id can't be greater than %d or less than 0", 31L));
        }
        this.workerId = workerId;
        this.dataCenterId = dataCenterId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Snowflake getInstance(long workerId, long dataCenterId) {
        if (instance != null) return instance;
        Class<Snowflake> clazz = Snowflake.class;
        synchronized (Snowflake.class) {
            if (instance != null) return instance;
            instance = new Snowflake(workerId, dataCenterId);
            // ** MonitorExit[var4_2] (shouldn't be in output)
            return instance;
        }
    }

    synchronized long nextId() {
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards. Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - 1543593600000L << 22 | this.dataCenterId << 17 | this.workerId << 12 | this.sequence;
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }
}

