/*
 * Decompiled with CFR 0.152.
 */
package io.electrum.prepaidutility.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.electrum.prepaidutility.model.TaxableAmount;
import io.electrum.vas.Utils;
import io.electrum.vas.model.LedgerAmount;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;

@ApiModel(description="Represents a charge deducted from the purchase to recover outstanding debt")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DebtRecoveryCharge {
    private TaxableAmount amount = null;
    private String description = null;
    private LedgerAmount balance = null;
    private String receiptNum = null;

    public DebtRecoveryCharge amount(TaxableAmount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="Amount charged and tax levied for debt recovery, in minor denomination.")
    @NotNull
    @Valid
    public TaxableAmount getAmount() {
        return this.amount;
    }

    public void setAmount(TaxableAmount amount) {
        this.amount = amount;
    }

    public DebtRecoveryCharge description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(required=true, value="Description of this debt recovery charge (e.g. municipal rates arrears).")
    @NotNull
    @Length(max=40)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public DebtRecoveryCharge balance(LedgerAmount balance) {
        this.balance = balance;
        return this;
    }

    @ApiModelProperty(required=true, value="Remaining balance on this account.")
    @NotNull
    @Valid
    public LedgerAmount getBalance() {
        return this.balance;
    }

    public void setBalance(LedgerAmount balance) {
        this.balance = balance;
    }

    public DebtRecoveryCharge receiptNum(String receiptNum) {
        this.receiptNum = receiptNum;
        return this;
    }

    @ApiModelProperty(value="Receipt number for this charge.")
    @Length(max=30)
    public String getReceiptNum() {
        return this.receiptNum;
    }

    public void setReceiptNum(String receiptNum) {
        this.receiptNum = receiptNum;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DebtRecoveryCharge debtRecoveryCharge = (DebtRecoveryCharge)o;
        return Objects.equals((Object)this.amount, (Object)debtRecoveryCharge.amount) && Objects.equals(this.description, debtRecoveryCharge.description) && Objects.equals(this.balance, debtRecoveryCharge.balance) && Objects.equals(this.receiptNum, debtRecoveryCharge.receiptNum);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.description, this.balance, this.receiptNum});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DebtRecoveryCharge {\n");
        sb.append("    amount: ").append(Utils.toIndentedString((Object)((Object)this.amount))).append("\n");
        sb.append("    description: ").append(Utils.toIndentedString((Object)this.description)).append("\n");
        sb.append("    balance: ").append(Utils.toIndentedString((Object)this.balance)).append("\n");
        sb.append("    receiptNum: ").append(Utils.toIndentedString((Object)this.receiptNum)).append("\n");
        sb.append("}");
        return sb.toString();
    }
}

