/*
 * Decompiled with CFR 0.152.
 */
package io.electrum.prepaidutility.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.electrum.vas.Utils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;

@ApiModel(description="Represents the outcome of a completed transaction")
public class ErrorDetail {
    private ErrorType errorType = null;
    private String errorMessage = null;
    private RequestType requestType = null;
    private String id = null;
    private String originalId = null;
    private Object detailMessage = null;

    public ErrorDetail errorType(ErrorType errorType) {
        this.errorType = errorType;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of error that occurred")
    @JsonProperty(value="errorType")
    @NotNull
    public ErrorType getErrorType() {
        return this.errorType;
    }

    public void setErrorType(ErrorType errorType) {
        this.errorType = errorType;
    }

    public ErrorDetail errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @ApiModelProperty(required=true, value="A short description of the error")
    @JsonProperty(value="errorMessage")
    @NotNull
    @Length(max=20)
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public ErrorDetail requestType(RequestType requestType) {
        this.requestType = requestType;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of request being processed when the error occurred.")
    @JsonProperty(value="requestType")
    @NotNull
    public RequestType getRequestType() {
        return this.requestType;
    }

    public void setRequestType(RequestType requestType) {
        this.requestType = requestType;
    }

    public ErrorDetail id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The UUID of the message for which error occurred.")
    @JsonProperty(value="id")
    @NotNull
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ErrorDetail originalId(String originalId) {
        this.originalId = originalId;
        return this;
    }

    @ApiModelProperty(value="The UUID of the original request message in the case of an error occurring for an advice message.")
    @JsonProperty(value="originalId")
    public String getOriginalId() {
        return this.originalId;
    }

    public void setOriginalId(String originalId) {
        this.originalId = originalId;
    }

    public ErrorDetail detailMessage(Object detailMessage) {
        this.detailMessage = detailMessage;
        return this;
    }

    @ApiModelProperty(value="A free form detailed description of a particular failure condition may optionally be supplied")
    @JsonProperty(value="detailMessage")
    public Object getDetailMessage() {
        return this.detailMessage;
    }

    public void setDetailMessage(Object detailMessage) {
        this.detailMessage = detailMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ErrorDetail errorDetail = (ErrorDetail)o;
        return Objects.equals((Object)this.errorType, (Object)errorDetail.errorType) && Objects.equals(this.errorMessage, errorDetail.errorMessage) && Objects.equals((Object)this.requestType, (Object)errorDetail.requestType) && Objects.equals(this.id, errorDetail.id) && Objects.equals(this.originalId, errorDetail.originalId) && Objects.equals(this.detailMessage, errorDetail.detailMessage);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.errorType, this.errorMessage, this.requestType, this.id, this.originalId, this.detailMessage});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ErrorDetail {\n");
        sb.append("    errorType: ").append(Utils.toIndentedString((Object)((Object)this.errorType))).append("\n");
        sb.append("    responseMessage: ").append(Utils.toIndentedString((Object)this.errorMessage)).append("\n");
        sb.append("    requestType: ").append(Utils.toIndentedString((Object)((Object)this.requestType))).append("\n");
        sb.append("    id: ").append(Utils.toIndentedString((Object)this.id)).append("\n");
        sb.append("    originalId: ").append(Utils.toIndentedString((Object)this.originalId)).append("\n");
        sb.append("    detailMessage: ").append(Utils.toIndentedString((Object)this.detailMessage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public static enum RequestType {
        METER_LOOKUP_REQUEST("METER_LOOKUP_REQUEST"),
        TOKEN_PURCHASE_REQUEST("TOKEN_PURCHASE_REQUEST"),
        TOKEN_PURCHASE_RETRY_REQUEST("TOKEN_PURCHASE_RETRY_REQUEST"),
        TOKEN_REPRINT_REQUEST("TOKEN_REPRINT_REQUEST"),
        FAULT_REPORT_REQUEST("FAULT_REPORT_REQUEST"),
        KEY_CHANGE_TOKEN_REQUEST("KEY_CHANGE_TOKEN_REQUEST"),
        CONFIRMATION_ADVICE("CONFIRMATION_ADVICE"),
        REVERSAL_ADVICE("REVERSAL_ADVICE");

        private String value;

        private RequestType(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum ErrorType {
        DUPLICATE_RECORD("DUPLICATE_RECORD"),
        FORMAT_ERROR("FORMAT_ERROR"),
        FUNCTION_NOT_SUPPORTED("FUNCTION_NOT_SUPPORTED"),
        GENERAL_ERROR("GENERAL_ERROR"),
        INVALID_AMOUNT("INVALID_AMOUNT"),
        ROUTING_ERROR("ROUTING_ERROR"),
        TRANSACTION_NOT_SUPPORTED("TRANSACTION_NOT_SUPPORTED"),
        UNABLE_TO_LOCATE_RECORD("UNABLE_TO_LOCATE_RECORD"),
        UPSTREAM_UNAVAILABLE("UPSTREAM_UNAVAILABLE"),
        UNKNOWN_METER_ID("UNKNOWN_METER_ID"),
        TRANSACTION_DECLINED("TRANSACTION_DECLINED"),
        INVALID_MERCHANT("INVALID_MERCHANT"),
        INVALID_AN32_TOKEN("INVALID_AN32_TOKEN"),
        DO_NOT_HONOR("DO_NOT_HONOR"),
        INVALID_MSISDN("INVALID_MSISDN"),
        INVALID_LOYALTY_CARD("INVALID_LOYALTY_CARD");

        private String value;

        private ErrorType(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

