/*
 * Decompiled with CFR 0.152.
 */
package io.electrum.prepaidutility.model;

import io.electrum.prepaidutility.model.Meter;
import io.electrum.vas.Utils;
import io.electrum.vas.model.Customer;
import io.electrum.vas.model.Transaction;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;

@ApiModel(description="Data required to report a fault related to a specific meter")
public class FaultReportRequest
extends Transaction {
    private Meter meter = null;
    private Customer customer = null;
    private String contactNumber = null;
    private FaultType faultType = null;

    public FaultReportRequest meter(Meter meter) {
        this.meter = meter;
        return this;
    }

    @ApiModelProperty(required=true, value="Details of the meter for which fault is logged. The object must include at least a value for meterId.")
    @NotNull
    @Valid
    public Meter getMeter() {
        return this.meter;
    }

    public void setMeter(Meter meter) {
        this.meter = meter;
    }

    public Customer customer(Customer customer) {
        this.customer = customer;
        return customer;
    }

    @ApiModelProperty(value="Details of the person or organization to whom the meter belongs.")
    @Valid
    public Customer getCustomer() {
        return this.customer;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    public String contactNumber(String contactNumber) {
        this.contactNumber = contactNumber;
        return contactNumber;
    }

    @ApiModelProperty(required=true, value="Contact telephone number of the person reporting the fault")
    @NotNull
    @Length(max=20)
    public String getContactNumber() {
        return this.contactNumber;
    }

    public void setContactNumber(String contactNumber) {
        this.contactNumber = contactNumber;
    }

    public FaultType faultType(FaultType faultType) {
        this.faultType = faultType;
        return faultType;
    }

    @ApiModelProperty(required=true, value="Type of fault that is being reported")
    @NotNull
    public FaultType getFaultType() {
        return this.faultType;
    }

    public void setFaultType(FaultType faultType) {
        this.faultType = faultType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FaultReportRequest {\n");
        sb.append("    id: ").append(Utils.toIndentedString((Object)this.id)).append("\n");
        sb.append("    time: ").append(Utils.toIndentedString((Object)this.time)).append("\n");
        sb.append("    originator: ").append(Utils.toIndentedString((Object)this.originator)).append("\n");
        sb.append("    client: ").append(Utils.toIndentedString((Object)this.client)).append("\n");
        sb.append("    settlementEntity: ").append(Utils.toIndentedString((Object)this.settlementEntity)).append("\n");
        sb.append("    receiver: ").append(Utils.toIndentedString((Object)this.receiver)).append("\n");
        sb.append("    thirdPartyIdentifiers: ").append(Utils.toIndentedString((Object)this.thirdPartyIdentifiers)).append("\n");
        sb.append("    meter: ").append(Utils.toIndentedString((Object)this.meter)).append("\n");
        sb.append("    customer: ").append(Utils.toIndentedString((Object)this.customer)).append("\n");
        sb.append("    contactNumber: ").append(Utils.toIndentedString((Object)this.contactNumber)).append("\n");
        sb.append("    faultType: ").append(Utils.toIndentedString((Object)((Object)this.faultType))).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public static enum FaultType {
        SERIOUS_BOX_DAMAGE("SeriousBoxDamage"),
        FIRE_WATER_DAMAGE("FireWaterDamage"),
        METER_DEAD("MeterDead"),
        KEEPS_TRIPPING("KeepsTripping"),
        NO_TRIP("NoTrip"),
        DISPLAY_LIGHTS_BUTTONS("DisplayLightsButtons"),
        NETWORK_FAULT_REPORT("NetworkFaultReport"),
        INCORRECT_SGC("IncorrectSGC"),
        INCORRECT_TI("IncorrectTI"),
        CONVERTED_FRM_CONVENTIONAL("ConvertedFrmConventional"),
        METER_CHANGED_OUT("MeterChangedOut"),
        NEW_INSTALLATION("NewInstallation");

        private String value;

        private FaultType(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

