/*
 * Decompiled with CFR 0.152.
 */
package io.electrum.prepaidutility.model;

import io.electrum.vas.Utils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.Pattern;

@ApiModel(description="Represents updated meter encryption key data")
public class KeyChangeData {
    private String newSupplyGroupCode = null;
    private String newKeyRevisionNumber = null;
    private String newTariffIndex = null;

    public KeyChangeData newSupplyGroupCode(String newSupplyGroupCode) {
        this.newSupplyGroupCode = newSupplyGroupCode;
        return this;
    }

    @ApiModelProperty(value="New supply group code. Only relevant if this has been changed by the utility and a key change token has been issued.")
    @Pattern(regexp="[0-9]{6}")
    public String getNewSupplyGroupCode() {
        return this.newSupplyGroupCode;
    }

    public void setNewSupplyGroupCode(String newSupplyGroupCode) {
        this.newSupplyGroupCode = newSupplyGroupCode;
    }

    public KeyChangeData newKeyRevisionNumber(String newKeyRevisionNumber) {
        this.newKeyRevisionNumber = newKeyRevisionNumber;
        return this;
    }

    @ApiModelProperty(value="New key revision number. Only relevant if this has been changed by the utility and a key change token has been issued.")
    @Pattern(regexp="[0-9]{1}")
    public String getNewKeyRevisionNumber() {
        return this.newKeyRevisionNumber;
    }

    public void setNewKeyRevisionNumber(String newKeyRevisionNumber) {
        this.newKeyRevisionNumber = newKeyRevisionNumber;
    }

    public KeyChangeData newTariffIndex(String newTariffIndex) {
        this.newTariffIndex = newTariffIndex;
        return this;
    }

    @ApiModelProperty(value="New tariff index. Only relevant if this has been changed by the utility and a key change token has been issued.")
    @Pattern(regexp="[0-9]{2}")
    public String getNewTariffIndex() {
        return this.newTariffIndex;
    }

    public void setNewTariffIndex(String newTariffIndex) {
        this.newTariffIndex = newTariffIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyChangeData keyChangeData = (KeyChangeData)o;
        return Objects.equals(this.newSupplyGroupCode, keyChangeData.newSupplyGroupCode) && Objects.equals(this.newKeyRevisionNumber, keyChangeData.newKeyRevisionNumber) && Objects.equals(this.newTariffIndex, keyChangeData.newTariffIndex);
    }

    public int hashCode() {
        return Objects.hash(this.newSupplyGroupCode, this.newKeyRevisionNumber, this.newTariffIndex);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KeyChangeData {\n");
        sb.append("    newSupplyGroupCode: ").append(Utils.toIndentedString((Object)this.newSupplyGroupCode)).append("\n");
        sb.append("    newKeyRevisionNumber: ").append(Utils.toIndentedString((Object)this.newKeyRevisionNumber)).append("\n");
        sb.append("    newTariffIndex: ").append(Utils.toIndentedString((Object)this.newTariffIndex)).append("\n");
        sb.append("}");
        return sb.toString();
    }
}

