/*
 * Decompiled with CFR 0.152.
 */
package io.electrum.prepaidutility.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.electrum.prepaidutility.model.Meter;
import io.electrum.prepaidutility.model.Token;
import io.electrum.vas.Utils;
import io.electrum.vas.model.SlipData;
import io.electrum.vas.model.Transaction;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@ApiModel(description="Represents a response to a key change token request")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class KeyChangeTokenResponse
extends Transaction {
    private Meter meter = null;
    private List<Token> tokens = new ArrayList<Token>();
    private SlipData slipData = null;

    public KeyChangeTokenResponse meter(Meter meter) {
        this.meter = meter;
        return this;
    }

    @ApiModelProperty(required=true, value="Details of the meter.")
    @NotNull
    @Valid
    public Meter getMeter() {
        return this.meter;
    }

    public void setMeter(Meter meter) {
        this.meter = meter;
    }

    public KeyChangeTokenResponse tokens(List<Token> tokens) {
        this.tokens = tokens;
        return this;
    }

    public KeyChangeTokenResponse addTokensItem(Token tokensItem) {
        this.tokens.add(tokensItem);
        return this;
    }

    @ApiModelProperty(value="List of tokens issued for the key change.")
    @Valid
    public List<Token> getTokens() {
        return this.tokens;
    }

    public void setTokens(List<Token> tokens) {
        this.tokens = tokens;
    }

    public KeyChangeTokenResponse slipData(SlipData slipData) {
        this.slipData = slipData;
        return this;
    }

    @ApiModelProperty(value="A ready-to-print till slip. This is supplied by some providers either in addition to or in place of individual message elements. Where present, it must be used by POS to print the slip.")
    @Valid
    public SlipData getSlipData() {
        return this.slipData;
    }

    public void setSlipData(SlipData slipData) {
        this.slipData = slipData;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KeyChangeTokenResponse {\n");
        sb.append("    id: ").append(Utils.toIndentedString((Object)this.id)).append("\n");
        sb.append("    time: ").append(Utils.toIndentedString((Object)this.time)).append("\n");
        sb.append("    originator: ").append(Utils.toIndentedString((Object)this.originator)).append("\n");
        sb.append("    client: ").append(Utils.toIndentedString((Object)this.client)).append("\n");
        sb.append("    settlementEntity: ").append(Utils.toIndentedString((Object)this.settlementEntity)).append("\n");
        sb.append("    receiver: ").append(Utils.toIndentedString((Object)this.receiver)).append("\n");
        sb.append("    thirdPartyIdentifiers: ").append(Utils.toIndentedString((Object)this.thirdPartyIdentifiers)).append("\n");
        sb.append("    meter: ").append(Utils.toIndentedString((Object)this.meter)).append("\n");
        sb.append("    tokens: ").append(Utils.toIndentedString(this.tokens)).append("\n");
        sb.append("    slipData: ").append(Utils.toIndentedString((Object)this.slipData)).append("\n");
        sb.append("}");
        return sb.toString();
    }
}

