/*
 * Decompiled with CFR 0.152.
 */
package io.electrum.prepaidutility.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.electrum.prepaidutility.model.KeyChangeData;
import io.electrum.vas.Utils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

@ApiModel(description="Data associated with a prepaid utility meter")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Meter {
    private String meterId = null;
    private String track2Data = null;
    private String serviceType = null;
    private String supplyGroupCode = null;
    private String keyRevisionNum = null;
    private String tariffIndex = null;
    private String tokenTechCode = null;
    private String algorithmCode = null;
    private KeyChangeData keyChangeData = null;

    public Meter meterId(String meterId) {
        this.meterId = meterId;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique identifier for the meter (e.g. serial number).")
    @NotNull
    @Pattern(regexp="[a-zA-Z0-9]{0,20}")
    public String getMeterId() {
        return this.meterId;
    }

    public void setMeterId(String meterId) {
        this.meterId = meterId;
    }

    public Meter track2Data(String track2Data) {
        this.track2Data = track2Data;
        return this;
    }

    @ApiModelProperty(value="Track 2 data stored on the magnetic stripe of a card that is supplied with certain meters. This data contains all meter details. It can be used as an alternative means of input at PoS and may be required by some providers.")
    @Pattern(regexp="[a-zA-Z0-9=]{34}")
    public String getTrack2Data() {
        return this.track2Data;
    }

    public void setTrack2Data(String track2Data) {
        this.track2Data = track2Data;
    }

    public Meter serviceType(String serviceType) {
        this.serviceType = serviceType;
        return this;
    }

    @ApiModelProperty(value="Type of service dispensed by this meter (e.g. electricity, water or gas).")
    @Pattern(regexp="[a-zA-Z0-9]{0,12}")
    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public Meter supplyGroupCode(String supplyGroupCode) {
        this.supplyGroupCode = supplyGroupCode;
        return this;
    }

    @ApiModelProperty(value="Code used to identify a group of suppliers.")
    @Pattern(regexp="[0-9]{6}")
    public String getSupplyGroupCode() {
        return this.supplyGroupCode;
    }

    public void setSupplyGroupCode(String supplyGroupCode) {
        this.supplyGroupCode = supplyGroupCode;
    }

    public Meter keyRevisionNum(String keyRevisionNum) {
        this.keyRevisionNum = keyRevisionNum;
        return this;
    }

    @ApiModelProperty(value="Key revision number of the meter.")
    @Pattern(regexp="[0-9]{1}")
    public String getKeyRevisionNum() {
        return this.keyRevisionNum;
    }

    public void setKeyRevisionNum(String keyRevisionNum) {
        this.keyRevisionNum = keyRevisionNum;
    }

    public Meter tariffIndex(String tariffIndex) {
        this.tariffIndex = tariffIndex;
        return this;
    }

    @ApiModelProperty(value="Code representing the tariff associated with this meter.")
    @Pattern(regexp="[0-9]{2}")
    public String getTariffIndex() {
        return this.tariffIndex;
    }

    public void setTariffIndex(String tariffIndex) {
        this.tariffIndex = tariffIndex;
    }

    public Meter tokenTechCode(String tokenTechCode) {
        this.tokenTechCode = tokenTechCode;
        return this;
    }

    @ApiModelProperty(value="The means by which tokens are supplied for this meter (typically either numeric token or magnetic track).")
    @Pattern(regexp="[0-9]{2}")
    public String getTokenTechCode() {
        return this.tokenTechCode;
    }

    public void setTokenTechCode(String tokenTechCode) {
        this.tokenTechCode = tokenTechCode;
    }

    public Meter algorithmCode(String algorithmCode) {
        this.algorithmCode = algorithmCode;
        return this;
    }

    @ApiModelProperty(value="Code used to identify token encryption algorithm used by the meter.")
    @Pattern(regexp="[0-9]{2}")
    public String getAlgorithmCode() {
        return this.algorithmCode;
    }

    public void setAlgorithmCode(String algorithmCode) {
        this.algorithmCode = algorithmCode;
    }

    public Meter keyChangeData(KeyChangeData keyChangeData) {
        this.keyChangeData = keyChangeData;
        return this;
    }

    @ApiModelProperty(value="Represents new meter data in the case that these these have been updated.")
    @Valid
    public KeyChangeData getKeyChangeData() {
        return this.keyChangeData;
    }

    public void setKeyChangeData(KeyChangeData keyChangeData) {
        this.keyChangeData = keyChangeData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Meter meter = (Meter)o;
        return Objects.equals(this.meterId, meter.meterId) && Objects.equals(this.serviceType, meter.serviceType) && Objects.equals(this.track2Data, meter.track2Data) && Objects.equals(this.supplyGroupCode, meter.supplyGroupCode) && Objects.equals(this.keyRevisionNum, meter.keyRevisionNum) && Objects.equals(this.tariffIndex, meter.tariffIndex) && Objects.equals(this.tokenTechCode, meter.tokenTechCode) && Objects.equals(this.algorithmCode, meter.algorithmCode) && Objects.equals(this.keyChangeData, meter.keyChangeData);
    }

    public int hashCode() {
        return Objects.hash(this.meterId, this.track2Data, this.serviceType, this.supplyGroupCode, this.keyRevisionNum, this.tariffIndex, this.tokenTechCode, this.algorithmCode, this.keyChangeData);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Meter {\n");
        sb.append("    meterId: ").append(Utils.toIndentedString((Object)this.meterId)).append("\n");
        sb.append("    track2Data: ").append(Utils.toIndentedString((Object)this.track2Data)).append("\n");
        sb.append("    serviceType: ").append(Utils.toIndentedString((Object)this.serviceType)).append("\n");
        sb.append("    supplyGroupCode: ").append(Utils.toIndentedString((Object)this.supplyGroupCode)).append("\n");
        sb.append("    keyRevisionNum: ").append(Utils.toIndentedString((Object)this.keyRevisionNum)).append("\n");
        sb.append("    tariffIndex: ").append(Utils.toIndentedString((Object)this.tariffIndex)).append("\n");
        sb.append("    tokenTechCode: ").append(Utils.toIndentedString((Object)this.tokenTechCode)).append("\n");
        sb.append("    algorithmCode: ").append(Utils.toIndentedString((Object)this.algorithmCode)).append("\n");
        sb.append("    keyChangeData: ").append(Utils.toIndentedString((Object)this.keyChangeData)).append("\n");
        sb.append("}");
        return sb.toString();
    }
}

