/*
 * Decompiled with CFR 0.152.
 */
package io.electrum.prepaidutility.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.electrum.prepaidutility.model.Meter;
import io.electrum.prepaidutility.model.Utility;
import io.electrum.vas.Utils;
import io.electrum.vas.model.Customer;
import io.electrum.vas.model.LedgerAmount;
import io.electrum.vas.model.Transaction;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@ApiModel(description="Represents a response to a meter lookup request")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MeterLookupResponse
extends Transaction {
    private Meter meter = null;
    private Customer customer = null;
    private Utility utility = null;
    private LedgerAmount minAmount = null;
    private LedgerAmount maxAmount = null;
    private Boolean bsstDue = null;

    public MeterLookupResponse meter(Meter meter) {
        this.meter = meter;
        return this;
    }

    @ApiModelProperty(required=true, value="Details of the meter.")
    @NotNull
    @Valid
    public Meter getMeter() {
        return this.meter;
    }

    public void setMeter(Meter meter) {
        this.meter = meter;
    }

    public MeterLookupResponse customer(Customer customer) {
        this.customer = customer;
        return this;
    }

    @ApiModelProperty(required=true, value="Details of the person or organization to whom the meter belongs.")
    @NotNull
    @Valid
    public Customer getCustomer() {
        return this.customer;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    public MeterLookupResponse utility(Utility utility) {
        this.utility = utility;
        return this;
    }

    @ApiModelProperty(required=true, value="Details of the utility which manages this meter's account.")
    @NotNull
    @Valid
    public Utility getUtility() {
        return this.utility;
    }

    public void setUtility(Utility utility) {
        this.utility = utility;
    }

    public MeterLookupResponse minAmount(LedgerAmount minAmount) {
        this.minAmount = minAmount;
        return this;
    }

    @ApiModelProperty(value="Minimum purchase amount that can be requested by the customer.")
    @Valid
    public LedgerAmount getMinAmount() {
        return this.minAmount;
    }

    public void setMinAmount(LedgerAmount minAmount) {
        this.minAmount = minAmount;
    }

    public MeterLookupResponse maxAmount(LedgerAmount maxAmount) {
        this.maxAmount = maxAmount;
        return this;
    }

    @ApiModelProperty(value="Maximum purchase amount that can be requested by the customer.")
    @Valid
    public LedgerAmount getMaxAmount() {
        return this.maxAmount;
    }

    public void setMaxAmount(LedgerAmount maxAmount) {
        this.maxAmount = maxAmount;
    }

    public MeterLookupResponse bsstDue(Boolean bsstDue) {
        this.bsstDue = bsstDue;
        return this;
    }

    @ApiModelProperty(value="Boolean flag indicating whether a free basic service support token is owing on this meter. Not all meters support this and typically only one free token is issued per calendar month. If the value of this field is true, then a purchase request with an amount of 0 can be sent and the response will contain the free token.")
    public Boolean getBsstDue() {
        return this.bsstDue;
    }

    public void setBsstDue(Boolean bsstDue) {
        this.bsstDue = bsstDue;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MeterLookupResponse {\n");
        sb.append("    id: ").append(Utils.toIndentedString((Object)this.id)).append("\n");
        sb.append("    time: ").append(Utils.toIndentedString((Object)this.time)).append("\n");
        sb.append("    originator: ").append(Utils.toIndentedString((Object)this.originator)).append("\n");
        sb.append("    client: ").append(Utils.toIndentedString((Object)this.client)).append("\n");
        sb.append("    settlementEntity: ").append(Utils.toIndentedString((Object)this.settlementEntity)).append("\n");
        sb.append("    receiver: ").append(Utils.toIndentedString((Object)this.receiver)).append("\n");
        sb.append("    thirdPartyIdentifiers: ").append(Utils.toIndentedString((Object)this.thirdPartyIdentifiers)).append("\n");
        sb.append("    meter: ").append(Utils.toIndentedString((Object)this.meter)).append("\n");
        sb.append("    customer: ").append(Utils.toIndentedString((Object)this.customer)).append("\n");
        sb.append("    utility: ").append(Utils.toIndentedString((Object)this.utility)).append("\n");
        sb.append("    minAmount: ").append(Utils.toIndentedString((Object)this.minAmount)).append("\n");
        sb.append("    maxAmount: ").append(Utils.toIndentedString((Object)this.maxAmount)).append("\n");
        sb.append("    bsstDue: ").append(Utils.toIndentedString((Object)this.bsstDue)).append("\n");
        sb.append("}");
        return sb.toString();
    }
}

