/*
 * Decompiled with CFR 0.152.
 */
package io.electrum.prepaidutility.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.electrum.prepaidutility.model.PurchaseRequest;
import io.electrum.vas.Utils;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PurchaseRequestRetry {
    private String retryId = null;
    private PurchaseRequest originalRequest = null;

    public PurchaseRequestRetry retryId(String retryId) {
        this.retryId = retryId;
        return this;
    }

    public String getRetryId() {
        return this.retryId;
    }

    public void setRetryId(String retryId) {
        this.retryId = retryId;
    }

    public PurchaseRequestRetry originalRequest(PurchaseRequest originalRequest) {
        this.originalRequest = originalRequest;
        return this;
    }

    @ApiModelProperty(required=true, value="The original PurchaseRequest that is being retried")
    @NotNull
    @Valid
    public PurchaseRequest getOriginalRequest() {
        return this.originalRequest;
    }

    public void setOriginalRequest(PurchaseRequest originalRequest) {
        this.originalRequest = originalRequest;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PurchaseRequestRetry vasRequest = (PurchaseRequestRetry)o;
        return Objects.equals(this.retryId, vasRequest.retryId);
    }

    public int hashCode() {
        return Objects.hash(this.retryId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PurchaseRequestRetry {\n");
        sb.append("    retryId: ").append(Utils.toIndentedString((Object)this.retryId)).append("\n");
        sb.append("    originalRequest: ").append(Utils.toIndentedString((Object)((Object)this.originalRequest))).append("\n");
        sb.append("}");
        return sb.toString();
    }
}

