/*
 * Decompiled with CFR 0.152.
 */
package io.electrum.prepaidutility.model;

import io.electrum.prepaidutility.model.TaxableAmount;
import io.electrum.vas.Utils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;

@ApiModel(description="Represents a service charge deducted from the purchase amount")
public class ServiceCharge {
    private TaxableAmount amount = null;
    private String description = null;

    public ServiceCharge amount(TaxableAmount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="Amount charged and tax levied for the service.")
    @NotNull
    @Valid
    public TaxableAmount getAmount() {
        return this.amount;
    }

    public void setAmount(TaxableAmount amount) {
        this.amount = amount;
    }

    public ServiceCharge description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(required=true, value="Description of this service charge (e.g. connection fee).")
    @NotNull
    @Length(max=40)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceCharge serviceCharge = (ServiceCharge)o;
        return Objects.equals((Object)this.amount, (Object)serviceCharge.amount) && Objects.equals(this.description, serviceCharge.description);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.description});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceCharge {\n");
        sb.append("    amount: ").append(Utils.toIndentedString((Object)((Object)this.amount))).append("\n");
        sb.append("    description: ").append(Utils.toIndentedString((Object)this.description)).append("\n");
        sb.append("}");
        return sb.toString();
    }
}

