/*
 * Decompiled with CFR 0.152.
 */
package io.electrum.prepaidutility.model;

import io.electrum.vas.Utils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;
import javax.validation.constraints.NotNull;

@ApiModel(description="Represents a block of units charged at a specific tariff")
public class TariffBlock {
    private BigDecimal units = null;
    private BigDecimal rate = null;

    public TariffBlock units(BigDecimal units) {
        this.units = units;
        return this;
    }

    @ApiModelProperty(required=true, value="Number of units in this tariff block.")
    @NotNull
    public BigDecimal getUnits() {
        return this.units;
    }

    public void setUnits(BigDecimal units) {
        this.units = units;
    }

    public TariffBlock rate(BigDecimal rate) {
        this.rate = rate;
        return this;
    }

    @ApiModelProperty(required=true, value="Tariff rate for this block in minor denomination.")
    @NotNull
    public BigDecimal getRate() {
        return this.rate;
    }

    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TariffBlock tariffBlock = (TariffBlock)o;
        return Objects.equals(this.units, tariffBlock.units) && Objects.equals(this.rate, tariffBlock.rate);
    }

    public int hashCode() {
        return Objects.hash(this.units, this.rate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TariffBlock {\n");
        sb.append("    units: ").append(Utils.toIndentedString((Object)this.units)).append("\n");
        sb.append("    rate: ").append(Utils.toIndentedString((Object)this.rate)).append("\n");
        sb.append("}");
        return sb.toString();
    }
}

