/*
 * Decompiled with CFR 0.152.
 */
package io.electrum.prepaidutility.model;

import io.electrum.vas.Utils;
import io.electrum.vas.model.LedgerAmount;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;
import org.hibernate.validator.constraints.Length;

@ApiModel(description="Represents an amount on which tax has been levied")
public class TaxableAmount
extends LedgerAmount {
    private Long tax = null;
    private String taxType = null;
    private BigDecimal taxRate = null;

    public TaxableAmount tax(Long tax) {
        this.tax = tax;
        return this;
    }

    @ApiModelProperty(value="Tax amount. Only present and non-zero if the amount field is exclusive of tax.")
    public Long getTax() {
        return this.tax;
    }

    public void setTax(Long tax) {
        this.tax = tax;
    }

    public TaxableAmount taxType(String taxType) {
        this.taxType = taxType;
        return this;
    }

    @ApiModelProperty(value="Description of the type of tax (e.g. VAT).")
    @Length(max=10)
    public String getTaxType() {
        return this.taxType;
    }

    public void setTaxType(String taxType) {
        this.taxType = taxType;
    }

    public TaxableAmount rate(BigDecimal rate) {
        this.taxRate = rate;
        return this;
    }

    @ApiModelProperty(value="Rate at which tax is levied, expressed as a percentage.")
    public BigDecimal getTaxRate() {
        return this.taxRate;
    }

    public void setTaxRate(BigDecimal rate) {
        this.taxRate = rate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        TaxableAmount tax = (TaxableAmount)((Object)o);
        return Objects.equals(this.amount, tax.amount) && Objects.equals(this.currency, tax.currency) && Objects.equals(this.ledgerIndicator, tax.ledgerIndicator) && Objects.equals(this.tax, tax.tax) && Objects.equals(this.taxType, tax.taxType) && Objects.equals(this.taxRate, tax.taxRate);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.currency, this.ledgerIndicator, this.tax, this.taxType, this.taxRate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaxableAmount {\n");
        sb.append("    amount: ").append(Utils.toIndentedString((Object)this.amount)).append("\n");
        sb.append("    currency: ").append(Utils.toIndentedString((Object)this.currency)).append("\n");
        sb.append("    ledgerIndicator: ").append(Utils.toIndentedString((Object)this.ledgerIndicator)).append("\n");
        sb.append("    tax: ").append(Utils.toIndentedString((Object)this.tax)).append("\n");
        sb.append("    taxType: ").append(Utils.toIndentedString((Object)this.taxType)).append("\n");
        sb.append("    taxRate: ").append(Utils.toIndentedString((Object)this.taxRate)).append("\n");
        sb.append("}");
        return sb.toString();
    }
}

