/*
 * Decompiled with CFR 0.152.
 */
package io.electrum.prepaidutility.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.electrum.prepaidutility.model.TariffBlock;
import io.electrum.prepaidutility.model.TaxableAmount;
import io.electrum.vas.Utils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@ApiModel(description="Represents a prepaid utility token")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Token {
    private TokenTypeEnum tokenType = null;
    private BigDecimal units = null;
    private TaxableAmount amount = null;
    private String receiptNum = null;
    private String token = null;
    private List<TariffBlock> tariffCalc = new ArrayList<TariffBlock>();

    public Token tokenType(TokenTypeEnum tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    @ApiModelProperty(required=true, value="Type of token, namely standard (STD), basic service support tariff (BSST), refund (REFUND), key change (KC).")
    @NotNull
    public TokenTypeEnum getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(TokenTypeEnum tokenType) {
        this.tokenType = tokenType;
    }

    public Token units(BigDecimal units) {
        this.units = units;
        return this;
    }

    @ApiModelProperty(required=true, value="Number of units redeemable by this token.")
    @NotNull
    public BigDecimal getUnits() {
        return this.units;
    }

    public void setUnits(BigDecimal units) {
        this.units = units;
    }

    public Token amount(TaxableAmount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="Monetary value of the token")
    @NotNull
    @Valid
    public TaxableAmount getAmount() {
        return this.amount;
    }

    public void setAmount(TaxableAmount amount) {
        this.amount = amount;
    }

    public Token receiptNum(String receiptNum) {
        this.receiptNum = receiptNum;
        return this;
    }

    @ApiModelProperty(value="Receipt number issued for the transaction.")
    public String getReceiptNum() {
        return this.receiptNum;
    }

    public void setReceiptNum(String receiptNum) {
        this.receiptNum = receiptNum;
    }

    public Token token(String token) {
        this.token = token;
        return this;
    }

    @ApiModelProperty(required=true, value="Numeric sequence to be entered into the meter to redeem the token's value.")
    @NotNull
    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Token tariffCalc(List<TariffBlock> tariffCalc) {
        this.tariffCalc = tariffCalc;
        return this;
    }

    public Token addTariffCalcItem(TariffBlock tariffCalcItem) {
        this.tariffCalc.add(tariffCalcItem);
        return this;
    }

    @ApiModelProperty(value="List of tariff blocks determining how the overall tariff is calculated.")
    @Valid
    public List<TariffBlock> getTariffCalc() {
        return this.tariffCalc;
    }

    public void setTariffCalc(List<TariffBlock> tariffCalc) {
        this.tariffCalc = tariffCalc;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Token token = (Token)o;
        return Objects.equals((Object)this.tokenType, (Object)token.tokenType) && Objects.equals(this.units, token.units) && Objects.equals((Object)this.amount, (Object)token.amount) && Objects.equals(this.receiptNum, token.receiptNum) && Objects.equals(this.token, token.token) && Objects.equals(this.tariffCalc, token.tariffCalc);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tokenType, this.units, this.amount, this.receiptNum, this.token, this.tariffCalc});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Token {\n");
        sb.append("    tokenType: ").append(Utils.toIndentedString((Object)((Object)this.tokenType))).append("\n");
        sb.append("    units: ").append(Utils.toIndentedString((Object)this.units)).append("\n");
        sb.append("    amount: ").append(Utils.toIndentedString((Object)((Object)this.amount))).append("\n");
        sb.append("    receiptNum: ").append(Utils.toIndentedString((Object)this.receiptNum)).append("\n");
        sb.append("    token: ").append(Utils.toIndentedString((Object)this.token)).append("\n");
        sb.append("    tariffCalc: ").append(Utils.toIndentedString(this.tariffCalc)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public static enum TokenTypeEnum {
        STD("STD"),
        BSST("BSST"),
        REFUND("REFUND"),
        KC("KC");

        private String value;

        private TokenTypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

