/*
 * Decompiled with CFR 0.152.
 */
package io.electrum.prepaidutility.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.electrum.prepaidutility.model.Meter;
import io.electrum.vas.Utils;
import io.electrum.vas.model.Transaction;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@ApiModel(description="Represents a request for a token reprint")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TokenReprintRequest
extends Transaction {
    private Meter meter = null;
    private String originalRef = null;

    public TokenReprintRequest meterId(Meter meter) {
        this.meter = meter;
        return this;
    }

    @ApiModelProperty(required=true, value="Details of the meter for which a token reprint is requested. The object must include at least a value for meterId.")
    @NotNull
    @Valid
    public Meter getMeter() {
        return this.meter;
    }

    public void setMeter(Meter meter) {
        this.meter = meter;
    }

    public TokenReprintRequest originalRef(String originalRef) {
        this.originalRef = originalRef;
        return this;
    }

    @ApiModelProperty(value="Reference or receipt number for the original token in the case that a specific token is requested. If this field is not present, then the last-issued token will be requested from the provider.")
    public String getOriginalRef() {
        return this.originalRef;
    }

    public void setOriginalRef(String originalRef) {
        this.originalRef = originalRef;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TokenReprintRequest {\n");
        sb.append("    id: ").append(Utils.toIndentedString((Object)this.id)).append("\n");
        sb.append("    time: ").append(Utils.toIndentedString((Object)this.time)).append("\n");
        sb.append("    originator: ").append(Utils.toIndentedString((Object)this.originator)).append("\n");
        sb.append("    client: ").append(Utils.toIndentedString((Object)this.client)).append("\n");
        sb.append("    settlementEntity: ").append(Utils.toIndentedString((Object)this.settlementEntity)).append("\n");
        sb.append("    receiver: ").append(Utils.toIndentedString((Object)this.receiver)).append("\n");
        sb.append("    thirdPartyIdentifiers: ").append(Utils.toIndentedString((Object)this.thirdPartyIdentifiers)).append("\n");
        sb.append("    meter: ").append(Utils.toIndentedString((Object)this.meter)).append("\n");
        sb.append("    originalRef: ").append(Utils.toIndentedString((Object)this.originalRef)).append("\n");
        sb.append("    slipData: ").append(Utils.toIndentedString((Object)this.slipData)).append("\n");
        sb.append("}");
        return sb.toString();
    }
}

