/*
 * Decompiled with CFR 0.152.
 */
package io.electrum.prepaidutility.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.electrum.vas.Utils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.hibernate.validator.constraints.Length;

@ApiModel(description="Represents a utility with whom a meter is registered")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Utility {
    private String name = null;
    private String address = null;
    private String vatRegNum = null;
    private String clientId = null;
    private String message = null;

    public Utility name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Name of the utility.")
    @Length(max=40)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Utility address(String address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(value="Physical address of the utility.")
    @Length(max=80)
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Utility vatRegNum(String vatRegNum) {
        this.vatRegNum = vatRegNum;
        return this;
    }

    @ApiModelProperty(value="VAT registration number of the utility.")
    @Length(max=10)
    public String getVatRegNum() {
        return this.vatRegNum;
    }

    public void setVatRegNum(String vatRegNum) {
        this.vatRegNum = vatRegNum;
    }

    public Utility clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @ApiModelProperty(value="Identifier assigned by the utility to the client connecting to the utility's token issuing service.")
    @Length(max=20)
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public Utility message(String message) {
        this.message = message;
        return this;
    }

    @ApiModelProperty(value="Message send by the utility to be displayed on the customer receipt.")
    @Length(max=80)
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Utility utility = (Utility)o;
        return Objects.equals(this.name, utility.name) && Objects.equals(this.address, utility.address) && Objects.equals(this.vatRegNum, utility.vatRegNum) && Objects.equals(this.clientId, utility.clientId) && Objects.equals(this.message, utility.message);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.address, this.vatRegNum, this.clientId, this.message);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Utility {\n");
        sb.append("    name: ").append(Utils.toIndentedString((Object)this.name)).append("\n");
        sb.append("    address: ").append(Utils.toIndentedString((Object)this.address)).append("\n");
        sb.append("    vatRegNum: ").append(Utils.toIndentedString((Object)this.vatRegNum)).append("\n");
        sb.append("    clientId: ").append(Utils.toIndentedString((Object)this.clientId)).append("\n");
        sb.append("    message: ").append(Utils.toIndentedString((Object)this.message)).append("\n");
        sb.append("}");
        return sb.toString();
    }
}

