

                        

package io.fabric8.camelk.client.handlers.v1;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.camelk.client.internal.v1.CamelCatalogOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.camelk.v1.CamelCatalog;
import io.fabric8.camelk.v1.CamelCatalogBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class CamelCatalogHandler implements ResourceHandler<CamelCatalog, CamelCatalogBuilder> {

  @Override
  public String getKind() {
    return CamelCatalog.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "camel.apache.org/v1";
      }

  @Override
  public CamelCatalog create(OkHttpClient client, Config config, String namespace, CamelCatalog item, boolean dryRun) {
    return new CamelCatalogOperationsImpl(client, config).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public CamelCatalog replace(OkHttpClient client, Config config, String namespace, CamelCatalog item, boolean dryRun) {
    return new CamelCatalogOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public CamelCatalog reload(OkHttpClient client, Config config, String namespace, CamelCatalog item) {
    return new CamelCatalogOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public CamelCatalogBuilder edit(CamelCatalog item) {
    return new CamelCatalogBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, CamelCatalog item, boolean dryRun) {
    return new CamelCatalogOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, CamelCatalog item, Watcher<CamelCatalog> watcher) {
    return new CamelCatalogOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, CamelCatalog item, String resourceVersion, Watcher<CamelCatalog> watcher) {
    return new CamelCatalogOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, CamelCatalog item, ListOptions listOptions, Watcher<CamelCatalog> watcher) {
    return new CamelCatalogOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(listOptions, watcher);
  }

  @Override
  public CamelCatalog waitUntilReady(OkHttpClient client, Config config, String namespace, CamelCatalog item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new CamelCatalogOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public CamelCatalog waitUntilCondition(OkHttpClient client, Config config, String namespace, CamelCatalog item, Predicate<CamelCatalog> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new CamelCatalogOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
