

                        

package io.fabric8.camelk.client.handlers.v1;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.camelk.client.internal.v1.IntegrationOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.camelk.v1.Integration;
import io.fabric8.camelk.v1.IntegrationBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class IntegrationHandler implements ResourceHandler<Integration, IntegrationBuilder> {

  @Override
  public String getKind() {
    return Integration.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "camel.apache.org/v1";
      }

  @Override
  public Integration create(OkHttpClient client, Config config, String namespace, Integration item, boolean dryRun) {
    return new IntegrationOperationsImpl(client, config).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public Integration replace(OkHttpClient client, Config config, String namespace, Integration item, boolean dryRun) {
    return new IntegrationOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public Integration reload(OkHttpClient client, Config config, String namespace, Integration item) {
    return new IntegrationOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public IntegrationBuilder edit(Integration item) {
    return new IntegrationBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, Integration item, boolean dryRun) {
    return new IntegrationOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Integration item, Watcher<Integration> watcher) {
    return new IntegrationOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Integration item, String resourceVersion, Watcher<Integration> watcher) {
    return new IntegrationOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Integration item, ListOptions listOptions, Watcher<Integration> watcher) {
    return new IntegrationOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(listOptions, watcher);
  }

  @Override
  public Integration waitUntilReady(OkHttpClient client, Config config, String namespace, Integration item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new IntegrationOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public Integration waitUntilCondition(OkHttpClient client, Config config, String namespace, Integration item, Predicate<Integration> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new IntegrationOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
