

                        

package io.fabric8.camelk.client.handlers.v1;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.camelk.client.internal.v1.IntegrationKitOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.camelk.v1.IntegrationKit;
import io.fabric8.camelk.v1.IntegrationKitBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class IntegrationKitHandler implements ResourceHandler<IntegrationKit, IntegrationKitBuilder> {

  @Override
  public String getKind() {
    return IntegrationKit.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "camel.apache.org/v1";
      }

  @Override
  public IntegrationKit create(OkHttpClient client, Config config, String namespace, IntegrationKit item, boolean dryRun) {
    return new IntegrationKitOperationsImpl(client, config).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public IntegrationKit replace(OkHttpClient client, Config config, String namespace, IntegrationKit item, boolean dryRun) {
    return new IntegrationKitOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public IntegrationKit reload(OkHttpClient client, Config config, String namespace, IntegrationKit item) {
    return new IntegrationKitOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public IntegrationKitBuilder edit(IntegrationKit item) {
    return new IntegrationKitBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, IntegrationKit item, boolean dryRun) {
    return new IntegrationKitOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, IntegrationKit item, Watcher<IntegrationKit> watcher) {
    return new IntegrationKitOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, IntegrationKit item, String resourceVersion, Watcher<IntegrationKit> watcher) {
    return new IntegrationKitOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, IntegrationKit item, ListOptions listOptions, Watcher<IntegrationKit> watcher) {
    return new IntegrationKitOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(listOptions, watcher);
  }

  @Override
  public IntegrationKit waitUntilReady(OkHttpClient client, Config config, String namespace, IntegrationKit item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new IntegrationKitOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public IntegrationKit waitUntilCondition(OkHttpClient client, Config config, String namespace, IntegrationKit item, Predicate<IntegrationKit> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new IntegrationKitOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
