

                        

package io.fabric8.camelk.client.handlers.v1;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.camelk.client.internal.v1.IntegrationPlatformOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.camelk.v1.IntegrationPlatform;
import io.fabric8.camelk.v1.IntegrationPlatformBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class IntegrationPlatformHandler implements ResourceHandler<IntegrationPlatform, IntegrationPlatformBuilder> {

  @Override
  public String getKind() {
    return IntegrationPlatform.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "camel.apache.org/v1";
      }

  @Override
  public IntegrationPlatform create(OkHttpClient client, Config config, String namespace, IntegrationPlatform item, boolean dryRun) {
    return new IntegrationPlatformOperationsImpl(client, config).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public IntegrationPlatform replace(OkHttpClient client, Config config, String namespace, IntegrationPlatform item, boolean dryRun) {
    return new IntegrationPlatformOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public IntegrationPlatform reload(OkHttpClient client, Config config, String namespace, IntegrationPlatform item) {
    return new IntegrationPlatformOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public IntegrationPlatformBuilder edit(IntegrationPlatform item) {
    return new IntegrationPlatformBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, IntegrationPlatform item, boolean dryRun) {
    return new IntegrationPlatformOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, IntegrationPlatform item, Watcher<IntegrationPlatform> watcher) {
    return new IntegrationPlatformOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, IntegrationPlatform item, String resourceVersion, Watcher<IntegrationPlatform> watcher) {
    return new IntegrationPlatformOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, IntegrationPlatform item, ListOptions listOptions, Watcher<IntegrationPlatform> watcher) {
    return new IntegrationPlatformOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(listOptions, watcher);
  }

  @Override
  public IntegrationPlatform waitUntilReady(OkHttpClient client, Config config, String namespace, IntegrationPlatform item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new IntegrationPlatformOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public IntegrationPlatform waitUntilCondition(OkHttpClient client, Config config, String namespace, IntegrationPlatform item, Predicate<IntegrationPlatform> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new IntegrationPlatformOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
