

                        

package io.fabric8.camelk.client.handlers.v1alpha1;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.camelk.client.internal.v1alpha1.KameletBindingOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.camelk.v1alpha1.KameletBinding;
import io.fabric8.camelk.v1alpha1.KameletBindingBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class KameletBindingHandler implements ResourceHandler<KameletBinding, KameletBindingBuilder> {

  @Override
  public String getKind() {
    return KameletBinding.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "camel.apache.org/v1alpha1";
      }

  @Override
  public KameletBinding create(OkHttpClient client, Config config, String namespace, KameletBinding item, boolean dryRun) {
    return new KameletBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public KameletBinding replace(OkHttpClient client, Config config, String namespace, KameletBinding item, boolean dryRun) {
    return new KameletBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public KameletBinding reload(OkHttpClient client, Config config, String namespace, KameletBinding item) {
    return new KameletBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public KameletBindingBuilder edit(KameletBinding item) {
    return new KameletBindingBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, KameletBinding item, boolean dryRun) {
    return new KameletBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, KameletBinding item, Watcher<KameletBinding> watcher) {
    return new KameletBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, KameletBinding item, String resourceVersion, Watcher<KameletBinding> watcher) {
    return new KameletBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, KameletBinding item, ListOptions listOptions, Watcher<KameletBinding> watcher) {
    return new KameletBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(listOptions, watcher);
  }

  @Override
  public KameletBinding waitUntilReady(OkHttpClient client, Config config, String namespace, KameletBinding item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new KameletBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public KameletBinding waitUntilCondition(OkHttpClient client, Config config, String namespace, KameletBinding item, Predicate<KameletBinding> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new KameletBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
