

                        

package io.fabric8.camelk.client.handlers.v1alpha1;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.camelk.client.internal.v1alpha1.KameletOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.camelk.v1alpha1.Kamelet;
import io.fabric8.camelk.v1alpha1.KameletBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class KameletHandler implements ResourceHandler<Kamelet, KameletBuilder> {

  @Override
  public String getKind() {
    return Kamelet.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "camel.apache.org/v1alpha1";
      }

  @Override
  public Kamelet create(OkHttpClient client, Config config, String namespace, Kamelet item, boolean dryRun) {
    return new KameletOperationsImpl(client, config).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public Kamelet replace(OkHttpClient client, Config config, String namespace, Kamelet item, boolean dryRun) {
    return new KameletOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public Kamelet reload(OkHttpClient client, Config config, String namespace, Kamelet item) {
    return new KameletOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public KameletBuilder edit(Kamelet item) {
    return new KameletBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, Kamelet item, boolean dryRun) {
    return new KameletOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Kamelet item, Watcher<Kamelet> watcher) {
    return new KameletOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Kamelet item, String resourceVersion, Watcher<Kamelet> watcher) {
    return new KameletOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Kamelet item, ListOptions listOptions, Watcher<Kamelet> watcher) {
    return new KameletOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(listOptions, watcher);
  }

  @Override
  public Kamelet waitUntilReady(OkHttpClient client, Config config, String namespace, Kamelet item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new KameletOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public Kamelet waitUntilCondition(OkHttpClient client, Config config, String namespace, Kamelet item, Predicate<Kamelet> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new KameletOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
