

                        
      
package io.fabric8.camelk.client.internal.v1;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.camelk.v1.Build;
import io.fabric8.camelk.v1.BuildBuilder;
import io.fabric8.camelk.v1.BuildList;

import java.util.Map;
import java.util.TreeMap;


public class BuildOperationsImpl extends HasMetadataOperation<Build, BuildList, Resource<Build>> {

  public BuildOperationsImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public BuildOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("camel.apache.org")
    .withApiGroupVersion("v1")
    .withPlural("builds"));
    this.type = Build.class;
    this.listType = BuildList.class;
  }

  public BuildOperationsImpl newInstance(OperationContext context) {
    return new BuildOperationsImpl(context);
  }

  @Override
  public Build edit(Visitor... visitors) {
    return patch(new BuildBuilder(getMandatory()).accept(visitors).build());
  }
  
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
