

                        
      
package io.fabric8.camelk.client.internal.v1;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.camelk.v1.CamelCatalog;
import io.fabric8.camelk.v1.CamelCatalogBuilder;
import io.fabric8.camelk.v1.CamelCatalogList;

import java.util.Map;
import java.util.TreeMap;


public class CamelCatalogOperationsImpl extends HasMetadataOperation<CamelCatalog, CamelCatalogList, Resource<CamelCatalog>> {

  public CamelCatalogOperationsImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public CamelCatalogOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("camel.apache.org")
    .withApiGroupVersion("v1")
    .withPlural("camelcatalogs"));
    this.type = CamelCatalog.class;
    this.listType = CamelCatalogList.class;
  }

  public CamelCatalogOperationsImpl newInstance(OperationContext context) {
    return new CamelCatalogOperationsImpl(context);
  }

  @Override
  public CamelCatalog edit(Visitor... visitors) {
    return patch(new CamelCatalogBuilder(getMandatory()).accept(visitors).build());
  }
  
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
