

                        
      
package io.fabric8.camelk.client.internal.v1;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.camelk.v1.IntegrationKit;
import io.fabric8.camelk.v1.IntegrationKitBuilder;
import io.fabric8.camelk.v1.IntegrationKitList;

import java.util.Map;
import java.util.TreeMap;


public class IntegrationKitOperationsImpl extends HasMetadataOperation<IntegrationKit, IntegrationKitList, Resource<IntegrationKit>> {

  public IntegrationKitOperationsImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public IntegrationKitOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("camel.apache.org")
    .withApiGroupVersion("v1")
    .withPlural("integrationkits"));
    this.type = IntegrationKit.class;
    this.listType = IntegrationKitList.class;
  }

  public IntegrationKitOperationsImpl newInstance(OperationContext context) {
    return new IntegrationKitOperationsImpl(context);
  }

  @Override
  public IntegrationKit edit(Visitor... visitors) {
    return patch(new IntegrationKitBuilder(getMandatory()).accept(visitors).build());
  }
  
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
