

                        
      
package io.fabric8.camelk.client.internal.v1;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.camelk.v1.Integration;
import io.fabric8.camelk.v1.IntegrationBuilder;
import io.fabric8.camelk.v1.IntegrationList;

import java.util.Map;
import java.util.TreeMap;


public class IntegrationOperationsImpl extends HasMetadataOperation<Integration, IntegrationList, Resource<Integration>> {

  public IntegrationOperationsImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public IntegrationOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("camel.apache.org")
    .withApiGroupVersion("v1")
    .withPlural("integrations"));
    this.type = Integration.class;
    this.listType = IntegrationList.class;
  }

  public IntegrationOperationsImpl newInstance(OperationContext context) {
    return new IntegrationOperationsImpl(context);
  }

  @Override
  public Integration edit(Visitor... visitors) {
    return patch(new IntegrationBuilder(getMandatory()).accept(visitors).build());
  }
  
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
