

                        
      
package io.fabric8.camelk.client.internal.v1;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.camelk.v1.IntegrationPlatform;
import io.fabric8.camelk.v1.IntegrationPlatformBuilder;
import io.fabric8.camelk.v1.IntegrationPlatformList;

import java.util.Map;
import java.util.TreeMap;


public class IntegrationPlatformOperationsImpl extends HasMetadataOperation<IntegrationPlatform, IntegrationPlatformList, Resource<IntegrationPlatform>> {

  public IntegrationPlatformOperationsImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public IntegrationPlatformOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("camel.apache.org")
    .withApiGroupVersion("v1")
    .withPlural("integrationplatforms"));
    this.type = IntegrationPlatform.class;
    this.listType = IntegrationPlatformList.class;
  }

  public IntegrationPlatformOperationsImpl newInstance(OperationContext context) {
    return new IntegrationPlatformOperationsImpl(context);
  }

  @Override
  public IntegrationPlatform edit(Visitor... visitors) {
    return patch(new IntegrationPlatformBuilder(getMandatory()).accept(visitors).build());
  }
  
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
