

                        
      
package io.fabric8.camelk.client.internal.v1alpha1;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.camelk.v1alpha1.KameletBinding;
import io.fabric8.camelk.v1alpha1.KameletBindingBuilder;
import io.fabric8.camelk.v1alpha1.KameletBindingList;

import java.util.Map;
import java.util.TreeMap;


public class KameletBindingOperationsImpl extends HasMetadataOperation<KameletBinding, KameletBindingList, Resource<KameletBinding>> {

  public KameletBindingOperationsImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public KameletBindingOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("camel.apache.org")
    .withApiGroupVersion("v1alpha1")
    .withPlural("kameletbindings"));
    this.type = KameletBinding.class;
    this.listType = KameletBindingList.class;
  }

  public KameletBindingOperationsImpl newInstance(OperationContext context) {
    return new KameletBindingOperationsImpl(context);
  }

  @Override
  public KameletBinding edit(Visitor... visitors) {
    return patch(new KameletBindingBuilder(getMandatory()).accept(visitors).build());
  }
  
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
