

                        
      
package io.fabric8.camelk.client.internal.v1alpha1;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.camelk.v1alpha1.Kamelet;
import io.fabric8.camelk.v1alpha1.KameletBuilder;
import io.fabric8.camelk.v1alpha1.KameletList;

import java.util.Map;
import java.util.TreeMap;


public class KameletOperationsImpl extends HasMetadataOperation<Kamelet, KameletList, Resource<Kamelet>> {

  public KameletOperationsImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public KameletOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("camel.apache.org")
    .withApiGroupVersion("v1alpha1")
    .withPlural("kamelets"));
    this.type = Kamelet.class;
    this.listType = KameletList.class;
  }

  public KameletOperationsImpl newInstance(OperationContext context) {
    return new KameletOperationsImpl(context);
  }

  @Override
  public Kamelet edit(Visitor... visitors) {
    return patch(new KameletBuilder(getMandatory()).accept(visitors).build());
  }
  
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
