/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service.jclouds;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.api.CreateContainerBasicOptions;
import io.fabric8.api.CreateContainerOptions;
import io.fabric8.api.CreateRemoteContainerOptions;
import io.fabric8.api.jcip.NotThreadSafe;
import io.fabric8.service.jclouds.JCloudsInstanceType;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jclouds.compute.ComputeService;

@NotThreadSafe
public class CreateJCloudsContainerOptions
extends CreateContainerBasicOptions<CreateJCloudsContainerOptions>
implements CreateRemoteContainerOptions {
    private static final long serialVersionUID = 4489740280396972109L;
    @JsonProperty
    private final String osFamily;
    @JsonProperty
    private final String osVersion;
    @JsonProperty
    private final String imageId;
    @JsonProperty
    private final String hardwareId;
    @JsonProperty
    private final String locationId;
    @JsonProperty
    private final String group;
    @JsonProperty
    private final String user;
    @JsonProperty
    private final String password;
    @JsonProperty
    private final String contextName;
    @JsonProperty
    private final String providerName;
    @JsonProperty
    private final String apiName;
    @JsonProperty
    private final String endpoint;
    @JsonProperty
    private final JCloudsInstanceType instanceType;
    @JsonProperty
    private final String identity;
    @JsonProperty
    private final String credential;
    @JsonProperty
    private final String owner;
    @JsonProperty
    private final Map<String, String> serviceOptions;
    @JsonProperty
    private final Map<String, String> nodeOptions;
    @JsonProperty
    private final int servicePort;
    @JsonProperty
    private final String publicKeyFile;
    @JsonIgnore
    private final transient ComputeService computeService;
    @JsonProperty
    private final String path;
    @JsonProperty
    private final Map<String, String> environmentalVariables;

    CreateJCloudsContainerOptions(String bindAddress, String resolver, String globalResolver, String manualIp, int minimumPort, int maximumPort, Set<String> profiles, String version, Map<String, String> dataStoreProperties, int zooKeeperServerPort, int zooKeeperServerConnectionPort, String zookeeperPassword, boolean ensembleStart, boolean agentEnabled, boolean autoImportEnabled, String importPath, Map<String, String> users, String name, String parent, String providerType, boolean ensembleServer, String preferredAddress, Map<String, Properties> systemProperties, int number, URI proxyUri, String zookeeperUrl, String jvmOpts, boolean adminAccess, boolean clean, String osFamily, String osVersion, String imageId, String hardwareId, String locationId, String group, String user, String password, String contextName, String providerName, String apiName, String endpoint, JCloudsInstanceType instanceType, String identity, String credential, String owner, Map<String, String> serviceOptions, Map<String, String> nodeOptions, int servicePort, String publicKeyFile, ComputeService computeService, String path, Map<String, String> environmentalVariables) {
        super(bindAddress, resolver, globalResolver, manualIp, minimumPort, maximumPort, profiles, version, dataStoreProperties, zooKeeperServerPort, zooKeeperServerConnectionPort, zookeeperPassword, ensembleStart, agentEnabled, false, 0L, autoImportEnabled, importPath, users, name, parent, providerType, ensembleServer, preferredAddress, systemProperties, Integer.valueOf(number), proxyUri, zookeeperUrl, jvmOpts, adminAccess, clean);
        this.osFamily = osFamily;
        this.osVersion = osVersion;
        this.imageId = imageId;
        this.hardwareId = hardwareId;
        this.locationId = locationId;
        this.group = group;
        this.user = user;
        this.password = password;
        this.contextName = contextName;
        this.providerName = providerName;
        this.apiName = apiName;
        this.endpoint = endpoint;
        this.instanceType = instanceType;
        this.identity = identity;
        this.credential = credential;
        this.owner = owner;
        this.serviceOptions = serviceOptions;
        this.nodeOptions = nodeOptions;
        this.servicePort = servicePort;
        this.publicKeyFile = publicKeyFile;
        this.computeService = computeService;
        this.path = path;
        this.environmentalVariables = Collections.unmodifiableMap(new HashMap<String, String>(environmentalVariables));
    }

    public CreateContainerOptions updateCredentials(String newUser, String newPassword) {
        return new CreateJCloudsContainerOptions(this.getBindAddress(), this.getResolver(), this.getGlobalResolver(), this.getManualIp(), this.getMinimumPort(), this.getMaximumPort(), this.getProfiles(), this.getVersion(), this.getDataStoreProperties(), this.getZooKeeperServerPort(), this.getZooKeeperServerConnectionPort(), this.getZookeeperPassword(), this.isEnsembleStart(), this.isAgentEnabled(), this.isAutoImportEnabled(), this.getImportPath(), this.getUsers(), this.getName(), this.getParent(), "jclouds", this.isEnsembleServer(), this.getPreferredAddress(), this.getSystemProperties(), this.getNumber(), this.getProxyUri(), this.getZookeeperUrl(), this.getJvmOpts(), this.isAdminAccess(), this.isClean(), this.osFamily, this.osVersion, this.imageId, this.hardwareId, this.locationId, this.group, newUser != null ? newUser : this.user, newPassword != null ? newPassword : this.password, this.contextName, this.providerName, this.apiName, this.endpoint, this.instanceType, this.identity, this.credential, this.owner, this.serviceOptions, this.nodeOptions, this.servicePort, this.publicKeyFile, this.computeService, this.path, this.environmentalVariables);
    }

    CreateJCloudsContainerOptions updateComputeService(ComputeService computeService) {
        return new CreateJCloudsContainerOptions(this.getBindAddress(), this.getResolver(), this.getGlobalResolver(), this.getManualIp(), this.getMinimumPort(), this.getMaximumPort(), this.getProfiles(), this.getVersion(), this.getDataStoreProperties(), this.getZooKeeperServerPort(), this.getZooKeeperServerConnectionPort(), this.getZookeeperPassword(), this.isEnsembleStart(), this.isAgentEnabled(), this.isAutoImportEnabled(), this.getImportPath(), this.getUsers(), this.getName(), this.getParent(), "jclouds", this.isEnsembleServer(), this.getPreferredAddress(), this.getSystemProperties(), this.getNumber(), this.getProxyUri(), this.getZookeeperUrl(), this.getJvmOpts(), this.isAdminAccess(), this.isClean(), this.osFamily, this.osVersion, this.imageId, this.hardwareId, this.locationId, this.group, this.user, this.password, this.contextName, this.providerName, this.apiName, this.endpoint, this.instanceType, this.identity, this.credential, this.owner, this.serviceOptions, this.nodeOptions, this.servicePort, this.publicKeyFile, computeService, this.path, this.environmentalVariables);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getHostNameContext() {
        return this.getProviderName();
    }

    public String getPath() {
        return this.path;
    }

    public Map<String, String> getEnvironmentalVariables() {
        return this.environmentalVariables;
    }

    public String getImageId() {
        return this.imageId;
    }

    public String getHardwareId() {
        return this.hardwareId;
    }

    public String getLocationId() {
        return this.locationId;
    }

    public String getGroup() {
        return this.group;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getContextName() {
        return this.contextName;
    }

    public String getProviderName() {
        return this.computeService != null ? this.computeService.getContext().unwrap().getProviderMetadata().getId() : this.providerName;
    }

    public String getApiName() {
        return this.computeService != null ? this.computeService.getContext().unwrap().getProviderMetadata().getApiMetadata().getId() : this.apiName;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public JCloudsInstanceType getInstanceType() {
        return this.instanceType;
    }

    public String getIdentity() {
        return this.identity;
    }

    public String getCredential() {
        return this.credential;
    }

    public String getOwner() {
        return this.owner;
    }

    public int getServicePort() {
        return this.servicePort;
    }

    public String getOsFamily() {
        return this.osFamily;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public String getPublicKeyFile() {
        return this.publicKeyFile;
    }

    public Map<String, String> getServiceOptions() {
        return this.serviceOptions;
    }

    public Map<String, String> getNodeOptions() {
        return this.nodeOptions;
    }

    public ComputeService getComputeService() {
        return this.computeService;
    }

    public CreateJCloudsContainerOptions clone() throws CloneNotSupportedException {
        return (CreateJCloudsContainerOptions)((Object)super.clone());
    }

    public String toString() {
        return "CreateJCloudsContainerArguments{imageId='" + this.imageId + '\'' + ", hardwareId='" + this.hardwareId + '\'' + ", locationId='" + this.locationId + '\'' + ", group='" + this.group + '\'' + ", user='" + this.user + '\'' + ", instanceType='" + (Object)((Object)this.instanceType) + '\'' + '}';
    }

    public static class Builder
    extends CreateContainerBasicOptions.Builder<Builder> {
        @JsonProperty
        private String osFamily;
        @JsonProperty
        private String osVersion;
        @JsonProperty
        private String imageId;
        @JsonProperty
        private String hardwareId;
        @JsonProperty
        private String locationId;
        @JsonProperty
        private String group;
        @JsonProperty
        private String user;
        @JsonProperty
        private String password;
        @JsonProperty
        private String contextName;
        @JsonProperty
        private String providerName;
        @JsonProperty
        private String apiName;
        @JsonProperty
        private String endpoint;
        @JsonProperty
        private JCloudsInstanceType instanceType = JCloudsInstanceType.Fastest;
        @JsonProperty
        private String identity;
        @JsonProperty
        private String credential;
        @JsonProperty
        private String owner;
        @JsonProperty
        private final Map<String, String> serviceOptions = new HashMap<String, String>();
        @JsonProperty
        private final Map<String, String> nodeOptions = new HashMap<String, String>();
        @JsonProperty
        private int servicePort = 0;
        @JsonProperty
        private String publicKeyFile;
        private transient ComputeService computeService;
        @JsonProperty
        private String path = "~/containers/";
        @JsonProperty
        private Map<String, String> environmentalVariables = new HashMap<String, String>();

        public Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            return this;
        }

        public Builder osFamily(String osFamily) {
            this.osFamily = osFamily;
            return this;
        }

        public Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public Builder hardwareId(String hardwareId) {
            this.hardwareId = hardwareId;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder group(String group) {
            this.group = group;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder computeService(ComputeService computeService) {
            this.computeService = computeService;
            return this;
        }

        public Builder contextName(String contextName) {
            this.contextName = contextName;
            return this;
        }

        public Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public Builder apiName(String apiName) {
            this.apiName = apiName;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder instanceType(JCloudsInstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public Builder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public Builder credential(String credential) {
            this.credential = credential;
            return this;
        }

        @Deprecated
        public Builder owner(String owner) {
            this.owner = owner;
            if (owner != null) {
                this.serviceOptions.put("owner", owner);
            }
            return this;
        }

        public Builder nodeOptions(Map<String, String> nodeOptions) {
            if (nodeOptions != null) {
                for (Map.Entry<String, String> entry : nodeOptions.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    this.nodeOptions.put(key, value);
                }
            }
            return this;
        }

        public Builder serviceOptions(Map<String, String> serviceOptions) {
            if (serviceOptions != null) {
                for (Map.Entry<String, String> entry : serviceOptions.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    this.serviceOptions.put(key, value);
                }
            }
            return this;
        }

        public Builder servicePort(int servicePort) {
            this.servicePort = servicePort;
            return this;
        }

        public Builder publicKeyFile(String publicKeyFile) {
            this.publicKeyFile = publicKeyFile;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder environmentalVariables(Map<String, String> environmentalVariables) {
            this.environmentalVariables = environmentalVariables;
            return this;
        }

        public Builder environmentalVariable(String key, String value) {
            this.environmentalVariables.put(key, value);
            return this;
        }

        public Builder environmentalVariable(String entry) {
            if (entry.contains("=")) {
                String key = entry.substring(0, entry.indexOf("="));
                String value = entry.substring(entry.indexOf("=") + 1);
                this.environmentalVariable(key, value);
            }
            return this;
        }

        public Builder environmentalVariable(List<String> entries) {
            if (entries != null) {
                for (String entry : entries) {
                    this.environmentalVariable(entry);
                }
            }
            return this;
        }

        public void setComputeService(ComputeService computeService) {
            this.computeService = computeService;
        }

        public String getOsFamily() {
            return this.osFamily;
        }

        public String getOsVersion() {
            return this.osVersion;
        }

        public String getImageId() {
            return this.imageId;
        }

        public String getHardwareId() {
            return this.hardwareId;
        }

        public String getLocationId() {
            return this.locationId;
        }

        public String getGroup() {
            return this.group;
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }

        public String getContextName() {
            return this.contextName;
        }

        public String getProviderName() {
            return this.providerName;
        }

        public String getApiName() {
            return this.apiName;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public JCloudsInstanceType getInstanceType() {
            return this.instanceType;
        }

        public String getIdentity() {
            return this.identity;
        }

        public String getCredential() {
            return this.credential;
        }

        public String getOwner() {
            return this.owner;
        }

        public Map<String, String> getServiceOptions() {
            return this.serviceOptions;
        }

        public Map<String, String> getNodeOptions() {
            return this.nodeOptions;
        }

        public int getServicePort() {
            return this.servicePort;
        }

        public String getPublicKeyFile() {
            return this.publicKeyFile;
        }

        public Object getComputeService() {
            return this.computeService;
        }

        public String getPath() {
            return this.path;
        }

        public void setEnvironmentalVariables(Map<String, String> environmentalVariables) {
            this.environmentalVariables = environmentalVariables;
        }

        public CreateJCloudsContainerOptions build() {
            return new CreateJCloudsContainerOptions(this.getBindAddress(), this.getResolver(), this.getGlobalResolver(), this.getManualIp(), this.getMinimumPort(), this.getMaximumPort(), this.getProfiles(), this.getVersion(), this.getDataStoreProperties(), this.getZooKeeperServerPort(), this.getZooKeeperServerConnectionPort(), this.getZookeeperPassword(), this.isEnsembleStart(), this.isAgentEnabled(), this.isAutoImportEnabled(), this.getImportPath(), this.getUsers(), this.getName(), this.getParent(), "jclouds", this.isEnsembleServer(), this.getPreferredAddress(), this.getSystemProperties(), this.getNumber(), this.getProxyUri(), this.getZookeeperUrl(), this.getJvmOpts(), this.isAdminAccess(), this.isClean(), this.osFamily, this.osVersion, this.imageId, this.hardwareId, this.locationId, this.group, this.user, this.password, this.contextName, this.providerName, this.apiName, this.endpoint, this.instanceType, this.identity, this.credential, this.owner, this.serviceOptions, this.nodeOptions, this.servicePort, this.publicKeyFile, this.computeService, this.path, this.environmentalVariables);
        }
    }
}

