/*
 * Decompiled with CFR 0.152.
 */
package io.flowcov.camunda.api.bpmn;

import io.flowcov.camunda.api.bpmn.FlowNode;
import java.util.ArrayList;
import java.util.Collection;

public class BpmnTestMethod {
    private String name;
    private double coverage;
    private Collection<FlowNode> flowNodes;
    private Collection<String> sequenceFlowIds;

    private static Collection<FlowNode> $default$flowNodes() {
        return new ArrayList<FlowNode>();
    }

    private static Collection<String> $default$sequenceFlowIds() {
        return new ArrayList<String>();
    }

    public static BpmnTestMethodBuilder builder() {
        return new BpmnTestMethodBuilder();
    }

    public String getName() {
        return this.name;
    }

    public double getCoverage() {
        return this.coverage;
    }

    public Collection<FlowNode> getFlowNodes() {
        return this.flowNodes;
    }

    public Collection<String> getSequenceFlowIds() {
        return this.sequenceFlowIds;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCoverage(double coverage) {
        this.coverage = coverage;
    }

    public void setFlowNodes(Collection<FlowNode> flowNodes) {
        this.flowNodes = flowNodes;
    }

    public void setSequenceFlowIds(Collection<String> sequenceFlowIds) {
        this.sequenceFlowIds = sequenceFlowIds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BpmnTestMethod)) {
            return false;
        }
        BpmnTestMethod other = (BpmnTestMethod)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        if (Double.compare(this.getCoverage(), other.getCoverage()) != 0) {
            return false;
        }
        Collection<FlowNode> this$flowNodes = this.getFlowNodes();
        Collection<FlowNode> other$flowNodes = other.getFlowNodes();
        if (this$flowNodes == null ? other$flowNodes != null : !((Object)this$flowNodes).equals(other$flowNodes)) {
            return false;
        }
        Collection<String> this$sequenceFlowIds = this.getSequenceFlowIds();
        Collection<String> other$sequenceFlowIds = other.getSequenceFlowIds();
        return !(this$sequenceFlowIds == null ? other$sequenceFlowIds != null : !((Object)this$sequenceFlowIds).equals(other$sequenceFlowIds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BpmnTestMethod;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        long $coverage = Double.doubleToLongBits(this.getCoverage());
        result = result * 59 + (int)($coverage >>> 32 ^ $coverage);
        Collection<FlowNode> $flowNodes = this.getFlowNodes();
        result = result * 59 + ($flowNodes == null ? 43 : ((Object)$flowNodes).hashCode());
        Collection<String> $sequenceFlowIds = this.getSequenceFlowIds();
        result = result * 59 + ($sequenceFlowIds == null ? 43 : ((Object)$sequenceFlowIds).hashCode());
        return result;
    }

    public String toString() {
        return "BpmnTestMethod(name=" + this.getName() + ", coverage=" + this.getCoverage() + ", flowNodes=" + this.getFlowNodes() + ", sequenceFlowIds=" + this.getSequenceFlowIds() + ")";
    }

    public BpmnTestMethod() {
        this.flowNodes = BpmnTestMethod.$default$flowNodes();
        this.sequenceFlowIds = BpmnTestMethod.$default$sequenceFlowIds();
    }

    public BpmnTestMethod(String name, double coverage, Collection<FlowNode> flowNodes, Collection<String> sequenceFlowIds) {
        this.name = name;
        this.coverage = coverage;
        this.flowNodes = flowNodes;
        this.sequenceFlowIds = sequenceFlowIds;
    }

    public static class BpmnTestMethodBuilder {
        private String name;
        private double coverage;
        private boolean flowNodes$set;
        private Collection<FlowNode> flowNodes$value;
        private boolean sequenceFlowIds$set;
        private Collection<String> sequenceFlowIds$value;

        BpmnTestMethodBuilder() {
        }

        public BpmnTestMethodBuilder name(String name) {
            this.name = name;
            return this;
        }

        public BpmnTestMethodBuilder coverage(double coverage) {
            this.coverage = coverage;
            return this;
        }

        public BpmnTestMethodBuilder flowNodes(Collection<FlowNode> flowNodes) {
            this.flowNodes$value = flowNodes;
            this.flowNodes$set = true;
            return this;
        }

        public BpmnTestMethodBuilder sequenceFlowIds(Collection<String> sequenceFlowIds) {
            this.sequenceFlowIds$value = sequenceFlowIds;
            this.sequenceFlowIds$set = true;
            return this;
        }

        public BpmnTestMethod build() {
            Collection<FlowNode> flowNodes$value = this.flowNodes$value;
            if (!this.flowNodes$set) {
                flowNodes$value = BpmnTestMethod.$default$flowNodes();
            }
            Collection<String> sequenceFlowIds$value = this.sequenceFlowIds$value;
            if (!this.sequenceFlowIds$set) {
                sequenceFlowIds$value = BpmnTestMethod.$default$sequenceFlowIds();
            }
            return new BpmnTestMethod(this.name, this.coverage, flowNodes$value, sequenceFlowIds$value);
        }

        public String toString() {
            return "BpmnTestMethod.BpmnTestMethodBuilder(name=" + this.name + ", coverage=" + this.coverage + ", flowNodes$value=" + this.flowNodes$value + ", sequenceFlowIds$value=" + this.sequenceFlowIds$value + ")";
        }
    }
}

