/*
 * Decompiled with CFR 0.152.
 */
package io.flowcov.camunda.junit.rules;

import io.flowcov.camunda.junit.rules.CoverageTestRunState;
import io.flowcov.camunda.junit.rules.CoverageTestRunStateFactory;
import io.flowcov.camunda.junit.rules.DefaultCoverageTestRunStateFactory;
import io.flowcov.camunda.junit.rules.MinimalCoverageMatcher;
import io.flowcov.camunda.listeners.CompensationEventCoverageHandler;
import io.flowcov.camunda.listeners.FlowNodeHistoryEventHandler;
import io.flowcov.camunda.listeners.PathCoverageParseListener;
import io.flowcov.camunda.model.AggregatedCoverage;
import io.flowcov.camunda.model.ClassCoverage;
import io.flowcov.camunda.util.CoverageReportUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.bpmn.parser.BpmnParseListener;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.event.EventHandler;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class FlowCovProcessEngineRule
extends ProcessEngineRule {
    private static Logger logger = Logger.getLogger(FlowCovProcessEngineRule.class.getCanonicalName());
    private CoverageTestRunState coverageTestRunState;
    private boolean firstRun = true;
    private boolean detailedCoverageLogging = false;
    private boolean handleClassCoverage = true;
    private CoverageTestRunStateFactory coverageTestRunStateFactory = new DefaultCoverageTestRunStateFactory();
    private Collection<Matcher<Double>> classCoverageAssertionMatchers = new LinkedList<Matcher<Double>>();
    private Map<String, Collection<Matcher<Double>>> testMethodNameToCoverageMatchers = new HashMap<String, Collection<Matcher<Double>>>();
    private List<String> excludedProcessDefinitionKeys;

    FlowCovProcessEngineRule() {
    }

    FlowCovProcessEngineRule(ProcessEngine processEngine) {
        super(processEngine);
    }

    public void addTestMethodCoverageAssertionMatcher(String testMethodName, Matcher<Double> matcher) {
        Collection<Matcher<Double>> matchers = this.testMethodNameToCoverageMatchers.get(testMethodName);
        if (matchers == null) {
            matchers = new LinkedList<Matcher<Double>>();
            this.testMethodNameToCoverageMatchers.put(testMethodName, matchers);
        }
        matchers.add(matcher);
    }

    public void addClassCoverageAssertionMatcher(MinimalCoverageMatcher matcher) {
        this.classCoverageAssertionMatchers.add((Matcher<Double>)matcher);
    }

    public void setExcludedProcessDefinitionKeys(List<String> excludedProcessDefinitionKeys) {
        this.excludedProcessDefinitionKeys = excludedProcessDefinitionKeys;
    }

    public void starting(Description description) {
        this.validateRuleAnnotations(description);
        if (this.processEngine == null) {
            super.initializeProcessEngine();
        }
        this.initializeRunState(description);
        super.starting(description);
        this.initializeMethodCoverage(description);
    }

    public void finished(Description description) {
        if (this.handleClassCoverage) {
            this.handleClassCoverage(description);
        }
        if (this.identityService != null) {
            super.finished(description);
        }
    }

    private void validateRuleAnnotations(Description description) {
        if (this.firstRun && !description.isTest()) {
            int numberOfCoverageRules = 0;
            for (Field field : description.getTestClass().getFields()) {
                Class<?> fieldType = field.getType();
                if (!((Object)((Object)this)).getClass().isAssignableFrom(fieldType)) continue;
                ++numberOfCoverageRules;
                boolean isClassRule = field.isAnnotationPresent(ClassRule.class);
                boolean isRule = field.isAnnotationPresent(Rule.class);
                if (!isClassRule || isRule) continue;
                throw new RuntimeException(((Object)((Object)this)).getClass().getCanonicalName() + " can only be used as a @ClassRule if it is also a @Rule!");
            }
            if (numberOfCoverageRules > 1) {
                throw new RuntimeException("Only one coverage rule can be used per test class!");
            }
        }
    }

    private void initializeMethodCoverage(Description description) {
        if (this.deploymentId != null) {
            List deployedProcessDefinitions = this.processEngine.getRepositoryService().createProcessDefinitionQuery().deploymentId(this.deploymentId).list();
            ArrayList<ProcessDefinition> relevantProcessDefinitions = new ArrayList<ProcessDefinition>();
            for (ProcessDefinition definition : deployedProcessDefinitions) {
                if (this.isExcluded(definition)) continue;
                relevantProcessDefinitions.add(definition);
            }
            this.coverageTestRunState.initializeTestMethodCoverage(this.processEngine, this.deploymentId, relevantProcessDefinitions, description.getMethodName());
        }
    }

    private void initializeRunState(Description description) {
        if (this.firstRun) {
            this.coverageTestRunState = this.coverageTestRunStateFactory.create(description.getClassName(), this.excludedProcessDefinitionKeys);
            this.initializeListenerRunState();
            this.firstRun = false;
        }
        this.coverageTestRunState.setCurrentTestMethodName(description.getMethodName());
    }

    private void initializeListenerRunState() {
        ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)this.processEngine.getProcessEngineConfiguration();
        FlowNodeHistoryEventHandler historyEventHandler = (FlowNodeHistoryEventHandler)processEngineConfiguration.getHistoryEventHandler();
        historyEventHandler.setCoverageTestRunState(this.coverageTestRunState);
        List bpmnParseListeners = processEngineConfiguration.getCustomPostBPMNParseListeners();
        for (BpmnParseListener parseListener : bpmnParseListeners) {
            if (!(parseListener instanceof PathCoverageParseListener)) continue;
            PathCoverageParseListener listener = (PathCoverageParseListener)parseListener;
            listener.setCoverageTestRunState(this.coverageTestRunState);
        }
        EventHandler compensationEventHandler = processEngineConfiguration.getEventHandler("compensate");
        if (compensationEventHandler instanceof CompensationEventCoverageHandler) {
            CompensationEventCoverageHandler compensationEventCoverageHandler = (CompensationEventCoverageHandler)compensationEventHandler;
            compensationEventCoverageHandler.setCoverageTestRunState(this.coverageTestRunState);
        } else {
            logger.warning("CompensationEventCoverageHandler not registered with process engine configuration! Compensation boundary events coverage will not be registered.");
        }
    }

    private void handleClassCoverage(Description description) {
        ClassCoverage classCoverage = this.coverageTestRunState.getClassCoverage();
        classCoverage.assertAllDeploymentsEqual();
        double classCoveragePercentage = classCoverage.getCoveragePercentage();
        logger.info(this.coverageTestRunState.getTestClassName() + " test class coverage is: " + classCoveragePercentage);
        this.logCoverageDetail(classCoverage);
        CoverageReportUtil.createClassReport(this.processEngine, this.coverageTestRunState);
        this.assertCoverage(classCoveragePercentage, this.classCoverageAssertionMatchers);
    }

    private void assertCoverage(double coverage, Collection<Matcher<Double>> matchers) {
        for (Matcher<Double> matcher : matchers) {
            Assert.assertThat((Object)coverage, matcher);
        }
    }

    private void logCoverageDetail(AggregatedCoverage coverage) {
        if (logger.isLoggable(Level.FINE) || this.isDetailedCoverageLogging()) {
            logger.log(Level.INFO, coverage.toString());
        }
    }

    private boolean isExcluded(ProcessDefinition processDefinition) {
        if (this.excludedProcessDefinitionKeys != null) {
            return this.excludedProcessDefinitionKeys.contains(processDefinition.getKey());
        }
        return false;
    }

    public boolean isDetailedCoverageLogging() {
        return this.detailedCoverageLogging;
    }

    public void setDetailedCoverageLogging(boolean detailedCoverageLogging) {
        this.detailedCoverageLogging = detailedCoverageLogging;
    }

    public void setHandleClassCoverage(boolean handleClassCoverage) {
        this.handleClassCoverage = handleClassCoverage;
    }

    public void setCoverageTestRunStateFactory(CoverageTestRunStateFactory coverageTestRunStateFactory) {
        this.coverageTestRunStateFactory = coverageTestRunStateFactory;
    }

    public Statement apply(Statement base, Description description) {
        return super.apply(base, description);
    }

    protected void succeeded(Description description) {
        super.succeeded(description);
        logger.info(description.getDisplayName() + " succeeded.");
    }

    protected void failed(Throwable e, Description description) {
        super.failed(e, description);
        logger.info(description.getDisplayName() + " failed.");
    }
}

