/*
 * Decompiled with CFR 0.152.
 */
package io.flowcov.camunda.model;

import io.flowcov.camunda.model.AggregatedCoverage;
import io.flowcov.camunda.model.CoveredElement;
import io.flowcov.camunda.model.CoveredFlowNode;
import io.flowcov.camunda.model.CoveredSequenceFlow;
import io.flowcov.camunda.model.MethodCoverage;
import io.flowcov.camunda.util.CoveredElementComparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.model.bpmn.instance.FlowNode;
import org.camunda.bpm.model.bpmn.instance.SequenceFlow;
import org.junit.Assert;

public class ClassCoverage
implements AggregatedCoverage {
    private Map<String, MethodCoverage> testNameToMethodCoverage = new HashMap<String, MethodCoverage>();

    public void addCoveredElement(String testName, CoveredElement coveredElement) {
        this.testNameToMethodCoverage.get(testName).addCoveredElement(coveredElement);
    }

    public void endCoveredElement(String currentTestMethodName, CoveredElement coveredElement) {
        this.testNameToMethodCoverage.get(currentTestMethodName).endCoveredElement(coveredElement);
    }

    public MethodCoverage getTestMethodCoverage(String testName) {
        return this.testNameToMethodCoverage.get(testName);
    }

    public Map<String, MethodCoverage> getTestMethodCoverage() {
        return this.testNameToMethodCoverage;
    }

    public void addTestMethodCoverage(String testName, MethodCoverage testCoverage) {
        this.testNameToMethodCoverage.put(testName, testCoverage);
    }

    @Override
    public double getCoveragePercentage() {
        MethodCoverage anyDeployment = this.getAnyMethodCoverage();
        Set<FlowNode> definitionsFlowNodes = anyDeployment.getProcessDefinitionsFlowNodes();
        Set<SequenceFlow> definitionsSeqenceFlows = anyDeployment.getProcessDefinitionsSequenceFlows();
        Set<CoveredFlowNode> coveredFlowNodes = this.getCoveredFlowNodes();
        Set<CoveredSequenceFlow> coveredSequenceFlows = this.getCoveredSequenceFlows();
        double bpmnElementsCount = definitionsFlowNodes.size() + definitionsSeqenceFlows.size();
        double coveredElementsCount = coveredFlowNodes.size() + coveredSequenceFlows.size();
        return coveredElementsCount / bpmnElementsCount;
    }

    @Override
    public double getCoveragePercentage(String processDefinitionKey) {
        MethodCoverage anyDeployment = this.getAnyMethodCoverage();
        Set<FlowNode> definitionsFlowNodes = anyDeployment.getProcessDefinitionsFlowNodes(processDefinitionKey);
        Set<SequenceFlow> definitionsSeqenceFlows = anyDeployment.getProcessDefinitionsSequenceFlows(processDefinitionKey);
        Set<CoveredFlowNode> coveredFlowNodes = this.getCoveredFlowNodes(processDefinitionKey);
        Set<CoveredSequenceFlow> coveredSequenceFlows = this.getCoveredSequenceFlows(processDefinitionKey);
        double bpmnElementsCount = definitionsFlowNodes.size() + definitionsSeqenceFlows.size();
        double coveredElementsCount = coveredFlowNodes.size() + coveredSequenceFlows.size();
        return coveredElementsCount / bpmnElementsCount;
    }

    public Set<CoveredFlowNode> getCoveredFlowNodes() {
        TreeSet<CoveredElement> coveredFlowNodes = new TreeSet<CoveredElement>(CoveredElementComparator.instance());
        for (MethodCoverage methodCoverage : this.testNameToMethodCoverage.values()) {
            coveredFlowNodes.addAll(methodCoverage.getCoveredFlowNodes());
        }
        return coveredFlowNodes;
    }

    @Override
    public Set<CoveredFlowNode> getCoveredFlowNodes(String processDefinitionKey) {
        TreeSet<CoveredElement> coveredFlowNodes = new TreeSet<CoveredElement>(CoveredElementComparator.instance());
        for (MethodCoverage methodCoverage : this.testNameToMethodCoverage.values()) {
            coveredFlowNodes.addAll(methodCoverage.getCoveredFlowNodes(processDefinitionKey));
        }
        return coveredFlowNodes;
    }

    @Override
    public Set<String> getCoveredFlowNodeIds(String processDefinitionKey) {
        HashSet<String> coveredFlowNodeIds = new HashSet<String>();
        for (MethodCoverage methodCoverage : this.testNameToMethodCoverage.values()) {
            coveredFlowNodeIds.addAll(methodCoverage.getCoveredFlowNodeIds(processDefinitionKey));
        }
        return coveredFlowNodeIds;
    }

    public Set<CoveredSequenceFlow> getCoveredSequenceFlows() {
        TreeSet<CoveredElement> coveredSequenceFlows = new TreeSet<CoveredElement>(CoveredElementComparator.instance());
        for (MethodCoverage deploymentCoverage : this.testNameToMethodCoverage.values()) {
            coveredSequenceFlows.addAll(deploymentCoverage.getCoveredSequenceFlows());
        }
        return coveredSequenceFlows;
    }

    @Override
    public Set<String> getCoveredSequenceFlowIds(String processDefinitionKey) {
        HashSet<String> coveredSequenceFlowIds = new HashSet<String>();
        for (MethodCoverage methodCoverage : this.testNameToMethodCoverage.values()) {
            coveredSequenceFlowIds.addAll(methodCoverage.getCoveredSequenceFlowIds(processDefinitionKey));
        }
        return coveredSequenceFlowIds;
    }

    @Override
    public Set<CoveredSequenceFlow> getCoveredSequenceFlows(String processDefinitionKey) {
        TreeSet<CoveredElement> coveredSequenceFlows = new TreeSet<CoveredElement>(CoveredElementComparator.instance());
        for (MethodCoverage methodCoverage : this.testNameToMethodCoverage.values()) {
            coveredSequenceFlows.addAll(methodCoverage.getCoveredSequenceFlows(processDefinitionKey));
        }
        return coveredSequenceFlows;
    }

    @Override
    public Set<ProcessDefinition> getProcessDefinitions() {
        return this.getAnyMethodCoverage().getProcessDefinitions();
    }

    protected MethodCoverage getAnyMethodCoverage() {
        MethodCoverage anyDeployment = this.testNameToMethodCoverage.values().iterator().next();
        return anyDeployment;
    }

    public void assertAllDeploymentsEqual() {
        Set<ProcessDefinition> processDefinitions = null;
        for (MethodCoverage methodCoverage : this.testNameToMethodCoverage.values()) {
            Set<ProcessDefinition> deploymentProcessDefinitions = methodCoverage.getProcessDefinitions();
            if (processDefinitions == null) {
                processDefinitions = deploymentProcessDefinitions;
            }
            Assert.assertEquals((String)"Class coverage can only be calculated if all tests deploy the same BPMN resources.", processDefinitions, deploymentProcessDefinitions);
        }
    }
}

