/*
 * Decompiled with CFR 0.152.
 */
package io.flowcov.camunda.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

public class Api {
    private static final Logger log = Logger.getLogger(Api.class.getCanonicalName());
    private String className;
    private String memberName;
    private Class<?>[] parameterTypes;
    private String signature;
    private static Map<String, Boolean> support = new HashMap<String, Boolean>();

    private Api(String className, String memberName, Class<?> ... parameterTypes) {
        this.className = className;
        this.memberName = memberName;
        this.parameterTypes = parameterTypes;
        this.signature = this.signature();
        if (!support.containsKey(this.signature)) {
            support.put(this.signature, this.supported());
        }
    }

    public static Api feature(String className) {
        return Api.feature(className, null, new Class[0]);
    }

    public static Api feature(String className, String memberName, Class<?> ... parameterTypes) {
        return new Api(className, memberName, parameterTypes);
    }

    public static Api feature(Class cls, String memberName, Class<?> ... parameterTypes) {
        return Api.feature(cls.getCanonicalName(), memberName, parameterTypes);
    }

    public void fail() {
        this.fail(this.message());
    }

    public void fail(String message) {
        if (!this.isSupported()) {
            throw new UnsupportedOperationException(message);
        }
    }

    public boolean warn() {
        return this.warn(this.message());
    }

    public boolean warn(String message) {
        Boolean supported = support.get(this.signature);
        if (supported != null && !supported.booleanValue()) {
            support.put(this.signature, null);
            log.warning(message);
        }
        return this.isSupported();
    }

    public boolean isSupported() {
        Boolean s = support.get(this.signature);
        return s != null && s != false;
    }

    public Object invoke(Object obj, Object ... args) {
        try {
            return this.method().invoke(obj, args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String message() {
        StringBuffer buffer = new StringBuffer("Usage of API '").append(this.signature).append("' requested, but not supported by the classes found in classpath.");
        return buffer.toString();
    }

    private String signature() {
        StringBuffer buffer = new StringBuffer(this.className);
        if (this.memberName != null) {
            buffer.append(".").append(this.memberName);
            buffer.append("(");
            if (this.parameterTypes != null && this.parameterTypes.length > 0) {
                Iterator<Class<?>> it = Arrays.asList(this.parameterTypes).iterator();
                while (it.hasNext()) {
                    buffer.append(it.next().getSimpleName());
                    if (!it.hasNext()) continue;
                    buffer.append(", ");
                }
            }
            buffer.append(")");
        }
        return buffer.toString();
    }

    private boolean supported() {
        return this.field() != null || this.method() != null;
    }

    private Method method() {
        Method method;
        try {
            method = Class.forName(this.className).getDeclaredMethod(this.memberName, this.parameterTypes);
            method.setAccessible(true);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        return method;
    }

    private Field field() {
        Field field;
        if (this.parameterTypes == null || this.parameterTypes.length > 0) {
            return null;
        }
        try {
            field = Class.forName(this.className).getDeclaredField(this.memberName);
            field.setAccessible(true);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        return field;
    }

    public static class Camunda {
        public static boolean supportsCompensationEventCoverage() {
            return Api.feature("org.camunda.bpm.engine.impl.bpmn.helper.BpmnProperties", "COMPENSATION_BOUNDARY_EVENT", new Class[0]).isSupported();
        }
    }
}

