/*
 * Decompiled with CFR 0.152.
 */
package io.flowcov.camunda.junit.rules;

import io.flowcov.camunda.junit.rules.CoverageTestRunStateFactory;
import io.flowcov.camunda.junit.rules.FlowCovProcessEngineRule;
import io.flowcov.camunda.junit.rules.MinimalCoverageMatcher;
import java.util.Arrays;
import org.camunda.bpm.engine.ProcessEngine;

public class FlowCovProcessEngineRuleBuilder {
    public static final String DEFAULT_ASSERT_AT_LEAST_PROPERTY = "org.camunda.bpm.extension.process_test_coverage.ASSERT_AT_LEAST";
    private final FlowCovProcessEngineRule rule;

    private FlowCovProcessEngineRuleBuilder() {
        this.rule = new FlowCovProcessEngineRule();
    }

    private FlowCovProcessEngineRuleBuilder(ProcessEngine processEngine) {
        this.rule = new FlowCovProcessEngineRule(processEngine);
    }

    public static FlowCovProcessEngineRuleBuilder create() {
        return FlowCovProcessEngineRuleBuilder.createBase().optionalAssertCoverageAtLeastProperty(DEFAULT_ASSERT_AT_LEAST_PROPERTY);
    }

    public static FlowCovProcessEngineRuleBuilder create(ProcessEngine processEngine) {
        return FlowCovProcessEngineRuleBuilder.createBase(processEngine).optionalAssertCoverageAtLeastProperty(DEFAULT_ASSERT_AT_LEAST_PROPERTY);
    }

    public FlowCovProcessEngineRuleBuilder optionalAssertCoverageAtLeastProperty(String key) {
        String assertAtLeast = System.getProperty(key);
        if (assertAtLeast != null) {
            try {
                MinimalCoverageMatcher minimalCoverageMatcher = new MinimalCoverageMatcher(Double.parseDouble(assertAtLeast));
                this.rule.addClassCoverageAssertionMatcher(minimalCoverageMatcher);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("BAD TEST CONFIGURATION: optionalAssertCoverageAtLeastProperty( \"" + key + "\" ) must be double");
            }
        }
        return this;
    }

    public static FlowCovProcessEngineRuleBuilder createBase() {
        return new FlowCovProcessEngineRuleBuilder();
    }

    public static FlowCovProcessEngineRuleBuilder createBase(ProcessEngine processEngine) {
        return new FlowCovProcessEngineRuleBuilder(processEngine);
    }

    public FlowCovProcessEngineRuleBuilder withDetailedCoverageLogging() {
        this.rule.setDetailedCoverageLogging(true);
        return this;
    }

    public FlowCovProcessEngineRuleBuilder handleClassCoverage(boolean needHandleClassCoverage) {
        this.rule.setHandleClassCoverage(needHandleClassCoverage);
        return this;
    }

    public FlowCovProcessEngineRuleBuilder setCoverageTestRunStateFactory(CoverageTestRunStateFactory coverageTestRunStateFactory) {
        this.rule.setCoverageTestRunStateFactory(coverageTestRunStateFactory);
        return this;
    }

    public FlowCovProcessEngineRuleBuilder assertClassCoverageAtLeast(double percentage) {
        if (0.0 > percentage || percentage > 1.0) {
            throw new RuntimeException("BAD TEST CONFIGURATION: coverageAtLeast " + percentage + " (" + 100.0 * percentage + "%) ");
        }
        this.rule.addClassCoverageAssertionMatcher(new MinimalCoverageMatcher(percentage));
        return this;
    }

    public FlowCovProcessEngineRuleBuilder excludeProcessDefinitionKeys(String ... processDefinitionKeys) {
        this.rule.setExcludedProcessDefinitionKeys(Arrays.asList(processDefinitionKeys));
        return this;
    }

    public FlowCovProcessEngineRule build() {
        return this.rule;
    }
}

