/*
 * Decompiled with CFR 0.152.
 */
package io.flowcov.camunda.listeners;

import io.flowcov.camunda.junit.rules.CoverageTestRunState;
import io.flowcov.camunda.model.CoveredFlowNode;
import io.flowcov.camunda.util.Api;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.camunda.bpm.engine.impl.bpmn.helper.BpmnProperties;
import org.camunda.bpm.engine.impl.event.CompensationEventHandler;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;

public class CompensationEventCoverageHandler
extends CompensationEventHandler {
    private CoverageTestRunState coverageTestRunState;
    private MethodHandle handleEvent;

    public void handleEvent(EventSubscriptionEntity eventSubscription, Object payload, Object localPayload, String businessKey, CommandContext commandContext) {
        this.addCompensationEventCoverage(eventSubscription);
        super.handleEvent(eventSubscription, payload, localPayload, businessKey, commandContext);
    }

    private void addCompensationEventCoverage(EventSubscriptionEntity eventSubscription) {
        if (Api.Camunda.supportsCompensationEventCoverage()) {
            ActivityImpl activity = eventSubscription.getActivity();
            ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)activity.getProcessDefinition();
            String processDefinitionKey = processDefinition.getKey();
            ActivityImpl sourceEvent = (ActivityImpl)activity.getProperty(BpmnProperties.COMPENSATION_BOUNDARY_EVENT.getName());
            if (sourceEvent != null) {
                String sourceEventId = sourceEvent.getActivityId();
                CoveredFlowNode compensationBoundaryEvent = new CoveredFlowNode(processDefinitionKey, sourceEventId);
                compensationBoundaryEvent.setEnded(true);
                this.coverageTestRunState.addCoveredElement(compensationBoundaryEvent);
            }
        }
    }

    public void setCoverageTestRunState(CoverageTestRunState coverageTestRunState) {
        this.coverageTestRunState = coverageTestRunState;
    }

    public void handleEvent(EventSubscriptionEntity eventSubscription, Object payload, CommandContext commandContext) {
        this.addCompensationEventCoverage(eventSubscription);
        try {
            if (this.handleEvent == null) {
                this.handleEvent = MethodHandles.lookup().findSpecial(CompensationEventHandler.class, "handleEvent", MethodType.methodType(Void.TYPE, EventSubscriptionEntity.class, Object.class, CommandContext.class), CompensationEventCoverageHandler.class);
            }
            this.handleEvent.invoke(this, eventSubscription, payload, commandContext);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

