/*
 * Decompiled with CFR 0.152.
 */
package io.flowcov.camunda.util;

import io.flowcov.camunda.api.Build;
import io.flowcov.camunda.api.bpmn.BpmnModel;
import io.flowcov.camunda.api.bpmn.BpmnTestClass;
import io.flowcov.camunda.api.bpmn.BpmnTestMethod;
import io.flowcov.camunda.api.bpmn.FlowNode;
import io.flowcov.camunda.junit.rules.CoverageTestRunState;
import io.flowcov.camunda.model.ClassCoverage;
import io.flowcov.camunda.util.FlowCovReporter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.repository.ProcessDefinition;

public class CoverageReportUtil {
    private static final Logger logger = Logger.getLogger(CoverageReportUtil.class.getCanonicalName());
    public static final String TARGET_DIR_ROOT = "target/flowcov/";

    public static void createClassReport(ProcessEngine processEngine, CoverageTestRunState coverageTestRunState) {
        ClassCoverage coverage = coverageTestRunState.getClassCoverage();
        String reportDirectory = CoverageReportUtil.getReportDirectoryPath();
        CoverageReportUtil.createReport(coverage, reportDirectory, coverageTestRunState.getTestClassName());
    }

    private static void createReport(ClassCoverage coverage, String reportDirectory, String testClazz) {
        try {
            Build run = Build.builder().build();
            for (ProcessDefinition definition : coverage.getProcessDefinitions()) {
                run.getBpmnModels().add(CoverageReportUtil.parseProcessDefinition(coverage, testClazz, definition));
            }
            FlowCovReporter.generateReport(reportDirectory + "/" + testClazz + "/flowCovReport.json", run);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Unable to load process definition!", ex);
            throw new RuntimeException();
        }
    }

    private static BpmnModel parseProcessDefinition(ClassCoverage coverage, String testClazz, ProcessDefinition processDefinition) throws IOException {
        String bpmnXml = CoverageReportUtil.getBpmnXml(processDefinition);
        BpmnModel model = BpmnModel.builder().bpmnXml(bpmnXml).processDefinitionKey(processDefinition.getKey()).name(processDefinition.getName()).version(processDefinition.getVersionTag()).hash(bpmnXml.hashCode()).build();
        List<BpmnTestMethod> testMethods = coverage.getTestMethodCoverage().values().stream().filter(m -> m.getName() != null).map(value -> {
            List<FlowNode> coveredFlowNodes = value.getCoveredFlowNodes(processDefinition.getKey()).stream().map(node -> FlowNode.builder().ended(node.hasEnded()).key(node.getElementId()).build()).collect(Collectors.toList());
            Set<String> coveredSequenceFlowIds = value.getCoveredSequenceFlowIds(processDefinition.getKey());
            return BpmnTestMethod.builder().flowNodes(coveredFlowNodes).sequenceFlowIds(coveredSequenceFlowIds).name(value.getName()).coverage(value.getCoveragePercentage(processDefinition.getKey())).build();
        }).collect(Collectors.toList());
        BpmnTestClass testClass = BpmnTestClass.builder().name(testClazz).executionEndTime(LocalDateTime.now()).testMethods(testMethods).build();
        model.getTestClasses().add(testClass);
        return model;
    }

    private static String getReportDirectoryPath() {
        return TARGET_DIR_ROOT;
    }

    protected static String getBpmnXml(ProcessDefinition processDefinition) throws IOException {
        InputStream inputStream = CoverageReportUtil.class.getClassLoader().getResourceAsStream(processDefinition.getResourceName());
        if (inputStream == null) {
            inputStream = new FileInputStream(processDefinition.getResourceName());
        }
        return IOUtils.toString((InputStream)inputStream);
    }
}

