/*
 * Copyright 2020 FlowSquad GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package io.flowcov.camunda.api;

import io.flowcov.camunda.api.bpmn.BpmnModel;
import io.flowcov.camunda.api.dmn.DmnModel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.List;

/**
 * Build Class that is send to FlowCov.
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class Build {

    @Builder.Default
    private List<BpmnModel> bpmnModels = new ArrayList<>();

    @Builder.Default
    private List<DmnModel> dmnModels = new ArrayList<>();
}

