/*
 * Decompiled with CFR 0.152.
 */
package io.flowcov.camunda.junit;

import io.flowcov.camunda.listeners.CompensationEventCoverageHandler;
import io.flowcov.camunda.listeners.CoverageHistoryEventHandler;
import io.flowcov.camunda.listeners.ElementCoverageParseListener;
import java.util.LinkedList;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.history.handler.HistoryEventHandler;

public class ProcessCoverageConfigurator {
    public static void initializeProcessCoverageExtensions(ProcessEngineConfigurationImpl configuration) {
        ProcessCoverageConfigurator.initializeCoverageHistoryHandler(configuration);
        ProcessCoverageConfigurator.initializeElementCoverageParseListener(configuration);
        ProcessCoverageConfigurator.initializeCompensationEventHandler(configuration);
    }

    private static void initializeElementCoverageParseListener(ProcessEngineConfigurationImpl configuration) {
        LinkedList<ElementCoverageParseListener> bpmnParseListeners = configuration.getCustomPostBPMNParseListeners();
        if (bpmnParseListeners == null) {
            bpmnParseListeners = new LinkedList<ElementCoverageParseListener>();
            configuration.setCustomPostBPMNParseListeners(bpmnParseListeners);
        }
        bpmnParseListeners.add(new ElementCoverageParseListener());
    }

    private static void initializeCoverageHistoryHandler(ProcessEngineConfigurationImpl configuration) {
        CoverageHistoryEventHandler historyEventHandler = new CoverageHistoryEventHandler();
        configuration.setHistoryEventHandler((HistoryEventHandler)historyEventHandler);
    }

    private static void initializeCompensationEventHandler(ProcessEngineConfigurationImpl configuration) {
        if (configuration.getCustomEventHandlers() == null) {
            configuration.setCustomEventHandlers(new LinkedList());
        }
        configuration.getCustomEventHandlers().add(new CompensationEventCoverageHandler());
    }
}

