/*
 * Decompiled with CFR 0.152.
 */
package io.flowcov.camunda.listeners;

import io.flowcov.camunda.junit.FlowCovTestRunState;
import io.flowcov.camunda.model.CoveredDmnRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.camunda.bpm.engine.history.HistoricDecisionOutputInstance;
import org.camunda.bpm.engine.impl.history.event.HistoricDecisionEvaluationEvent;
import org.camunda.bpm.engine.impl.history.event.HistoricDecisionInstanceEntity;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.history.handler.DbHistoryEventHandler;

public class CoverageHistoryEventHandler
extends DbHistoryEventHandler {
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getCanonicalName());
    private FlowCovTestRunState coverageTestRunState;

    public void handleEvent(HistoryEvent historyEvent) {
        super.handleEvent(historyEvent);
        if (historyEvent instanceof HistoricDecisionEvaluationEvent) {
            HistoricDecisionEvaluationEvent decisionEvent = (HistoricDecisionEvaluationEvent)historyEvent;
            List<CoveredDmnRule> rules = this.parseHistoricDecisionInstanceEntity(decisionEvent.getRootHistoricDecisionInstance());
            if (decisionEvent.getRequiredHistoricDecisionInstances() != null && !decisionEvent.getRequiredHistoricDecisionInstances().isEmpty()) {
                List requiredRules = decisionEvent.getRequiredHistoricDecisionInstances().stream().map(this::parseHistoricDecisionInstanceEntity).flatMap(Collection::stream).collect(Collectors.toList());
                rules.addAll(requiredRules);
            }
            this.coverageTestRunState.addCoveredRules(rules);
        }
    }

    private List<CoveredDmnRule> parseHistoricDecisionInstanceEntity(HistoricDecisionInstanceEntity instance) {
        if (instance.getOutputs() == null || instance.getOutputs().isEmpty()) {
            return new ArrayList<CoveredDmnRule>();
        }
        return instance.getOutputs().stream().map(HistoricDecisionOutputInstance::getRuleId).distinct().map(rule -> CoveredDmnRule.builder().decisionKey(instance.getDecisionDefinitionKey()).ruleId((String)rule).drdKey(instance.getDecisionRequirementsDefinitionKey()).build()).collect(Collectors.toList());
    }

    public void setCoverageTestRunState(FlowCovTestRunState coverageTestRunState) {
        this.coverageTestRunState = coverageTestRunState;
    }
}

