/*
 * Decompiled with CFR 0.152.
 */
package io.flowcov.camunda.model;

import io.flowcov.camunda.model.CoveredDmnRule;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.model.dmn.DmnModelInstance;
import org.camunda.bpm.model.dmn.instance.Decision;
import org.camunda.bpm.model.dmn.instance.DecisionRule;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public class DecisionCoverage {
    private static final Logger logger = Logger.getLogger(DecisionCoverage.class.getCanonicalName());
    private DecisionDefinition decisionDefinition;
    private Set<CoveredDmnRule> coveredDmnRules = new HashSet<CoveredDmnRule>();
    private Set<DecisionRule> definitionDecisionRules;

    public DecisionCoverage(ProcessEngine processEngine, DecisionDefinition decisionDefinition) {
        this.decisionDefinition = decisionDefinition;
        DmnModelInstance modelInstance = processEngine.getRepositoryService().getDmnModelInstance(this.getDecisionDefinitionId());
        this.definitionDecisionRules = this.getAssignedRules(modelInstance.getModelElementsByType(DecisionRule.class));
    }

    private Set<DecisionRule> getAssignedRules(Collection<DecisionRule> rules) {
        return rules.stream().filter(this::isAssigned).collect(Collectors.toSet());
    }

    private boolean isAssigned(ModelElementInstance node) {
        if (node == null) {
            return false;
        }
        if (node instanceof Decision) {
            return ((Decision)node).getId().equals(this.decisionDefinition.getKey());
        }
        return this.isAssigned(node.getParentElement());
    }

    public void addCoveredDmnRule(List<CoveredDmnRule> rules) {
        this.coveredDmnRules.addAll(rules);
    }

    public DecisionDefinition getDecisionDefintion() {
        return this.decisionDefinition;
    }

    public String getDecisionDefinitionId() {
        return this.decisionDefinition.getId();
    }

    public String getDecisionDefinitionKey() {
        return this.decisionDefinition.getKey();
    }

    public String toString() {
        return "DecisionCoverage(decisionDefinition=" + this.decisionDefinition + ", coveredDmnRules=" + this.getCoveredDmnRules() + ", definitionDecisionRules=" + this.getDefinitionDecisionRules() + ")";
    }

    public Set<CoveredDmnRule> getCoveredDmnRules() {
        return this.coveredDmnRules;
    }

    public Set<DecisionRule> getDefinitionDecisionRules() {
        return this.definitionDecisionRules;
    }
}

