/*
 * Decompiled with CFR 0.152.
 */
package io.flowcov.camunda.model;

import io.flowcov.camunda.model.AggregatedCoverage;
import io.flowcov.camunda.model.CoveredDmnRule;
import io.flowcov.camunda.model.CoveredElement;
import io.flowcov.camunda.model.CoveredFlowNode;
import io.flowcov.camunda.model.CoveredSequenceFlow;
import io.flowcov.camunda.model.DecisionCoverage;
import io.flowcov.camunda.model.ProcessCoverage;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;

public class MethodCoverage
implements AggregatedCoverage {
    private final String deploymentId;
    private final String name;
    private Map<String, ProcessCoverage> processDefinitionKeyToProcessCoverage = new HashMap<String, ProcessCoverage>();
    private Map<String, DecisionCoverage> decisionKeyToDecisionCoverage = new HashMap<String, DecisionCoverage>();

    public MethodCoverage(String deploymentId, String name) {
        this.deploymentId = deploymentId;
        this.name = name;
    }

    public void addProcessCoverage(ProcessCoverage processCoverage) {
        String processDefinitionId = processCoverage.getProcessDefinitionKey();
        this.processDefinitionKeyToProcessCoverage.put(processDefinitionId, processCoverage);
    }

    public void addDecisionCoverage(DecisionCoverage decisionCoverage) {
        String decisionDefinitionId = decisionCoverage.getDecisionDefinitionKey();
        this.decisionKeyToDecisionCoverage.put(decisionDefinitionId, decisionCoverage);
    }

    public void addCoveredElement(CoveredElement element) {
        String processDefinitionKey = element.getProcessDefinitionKey();
        ProcessCoverage processCoverage = this.processDefinitionKeyToProcessCoverage.get(processDefinitionKey);
        processCoverage.addCoveredElement(element);
    }

    public void endCoveredElement(CoveredElement element) {
        String processDefinitionKey = element.getProcessDefinitionKey();
        ProcessCoverage processCoverage = this.processDefinitionKeyToProcessCoverage.get(processDefinitionKey);
        processCoverage.endCoveredElement(element);
    }

    public void addCoveredDmnRules(List<CoveredDmnRule> coveredDmnRules) {
        Map<String, List<CoveredDmnRule>> decisionKey2coveredRuleMap = coveredDmnRules.stream().collect(Collectors.groupingBy(CoveredDmnRule::getDecisionKey));
        decisionKey2coveredRuleMap.forEach(this::addCoveredDmnRules);
    }

    private void addCoveredDmnRules(String decisionKey, List<CoveredDmnRule> coveredDmnRules) {
        DecisionCoverage decisionCoverage = this.decisionKeyToDecisionCoverage.get(decisionKey);
        decisionCoverage.addCoveredDmnRule(coveredDmnRules);
    }

    public List<CoveredFlowNode> getCoveredFlowNodes() {
        return this.processDefinitionKeyToProcessCoverage.values().stream().map(ProcessCoverage::getCoveredFlowNodes).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<CoveredSequenceFlow> getCoveredSequenceFlows() {
        return this.processDefinitionKeyToProcessCoverage.values().stream().map(ProcessCoverage::getCoveredSequenceFlows).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Integer getDecisionRuleCount(String decisionKey) {
        DecisionCoverage decisionCoverage = this.decisionKeyToDecisionCoverage.get(decisionKey);
        return decisionCoverage.getDefinitionDecisionRules().size();
    }

    public Integer getProcessElementCount(String processDefinitionKey) {
        ProcessCoverage processCoverage = this.processDefinitionKeyToProcessCoverage.get(processDefinitionKey);
        return processCoverage.getDefinitionFlowNodes().size() + processCoverage.getDefinitionSequenceFlows().size();
    }

    @Override
    public List<CoveredFlowNode> getCoveredFlowNodes(String processDefinitionKey) {
        ProcessCoverage processCoverage = this.processDefinitionKeyToProcessCoverage.get(processDefinitionKey);
        return processCoverage.getCoveredFlowNodes();
    }

    @Override
    public Set<CoveredDmnRule> getCoveredDecisionRules(String decisionKey) {
        DecisionCoverage decisionCoverage = this.decisionKeyToDecisionCoverage.get(decisionKey);
        return decisionCoverage.getCoveredDmnRules();
    }

    @Override
    public List<CoveredSequenceFlow> getCoveredSequenceFlows(String processDefinitionKey) {
        ProcessCoverage processCoverage = this.processDefinitionKeyToProcessCoverage.get(processDefinitionKey);
        return processCoverage.getCoveredSequenceFlows();
    }

    @Override
    public Set<ProcessDefinition> getProcessDefinitions() {
        TreeSet<ProcessDefinition> processDefinitions = new TreeSet<ProcessDefinition>(new Comparator<ProcessDefinition>(){

            @Override
            public int compare(ProcessDefinition o1, ProcessDefinition o2) {
                return o1.getResourceName().compareTo(o2.getResourceName());
            }
        });
        for (ProcessCoverage processCoverage : this.processDefinitionKeyToProcessCoverage.values()) {
            processDefinitions.add(processCoverage.getProcessDefinition());
        }
        return processDefinitions;
    }

    @Override
    public Set<DecisionDefinition> getDecisionDefinitions() {
        TreeSet<DecisionDefinition> decisionDefinitions = new TreeSet<DecisionDefinition>(new Comparator<DecisionDefinition>(){

            @Override
            public int compare(DecisionDefinition o1, DecisionDefinition o2) {
                return (o1.getKey() + o1.getResourceName()).compareTo(o2.getKey() + o2.getResourceName());
            }
        });
        for (DecisionCoverage decisionCoverage : this.decisionKeyToDecisionCoverage.values()) {
            decisionDefinitions.add(decisionCoverage.getDecisionDefintion());
        }
        return decisionDefinitions;
    }

    public String toString() {
        return "MethodCoverage(deploymentId=" + this.deploymentId + ", name=" + this.getName() + ", processDefinitionKeyToProcessCoverage=" + this.processDefinitionKeyToProcessCoverage + ", decisionKeyToDecisionCoverage=" + this.decisionKeyToDecisionCoverage + ")";
    }

    public String getName() {
        return this.name;
    }
}

