/*
 * Decompiled with CFR 0.152.
 */
package io.flowcov.camunda.model;

import io.flowcov.camunda.model.CoveredElement;
import io.flowcov.camunda.model.CoveredFlowNode;
import io.flowcov.camunda.model.CoveredSequenceFlow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.FlowNode;
import org.camunda.bpm.model.bpmn.instance.Process;
import org.camunda.bpm.model.bpmn.instance.SequenceFlow;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public class ProcessCoverage {
    private static final Logger logger = Logger.getLogger(ProcessCoverage.class.getCanonicalName());
    private ProcessDefinition processDefinition;
    private List<CoveredFlowNode> coveredFlowNodes = new ArrayList<CoveredFlowNode>();
    private Set<FlowNode> definitionFlowNodes;
    private List<CoveredSequenceFlow> coveredSequenceFlows = new ArrayList<CoveredSequenceFlow>();
    private Set<SequenceFlow> definitionSequenceFlows;

    public ProcessCoverage(ProcessEngine processEngine, ProcessDefinition processDefinition) {
        this.processDefinition = processDefinition;
        BpmnModelInstance modelInstance = processEngine.getRepositoryService().getBpmnModelInstance(this.getProcessDefinitionId());
        this.definitionFlowNodes = this.getExecutableFlowNodes(modelInstance.getModelElementsByType(FlowNode.class));
        this.definitionSequenceFlows = this.getExecutableSequenceNodes(modelInstance.getModelElementsByType(SequenceFlow.class));
    }

    public String getProcessDefinitionId() {
        return this.processDefinition.getId();
    }

    public String getProcessDefinitionKey() {
        return this.processDefinition.getKey();
    }

    private Set<FlowNode> getExecutableFlowNodes(Collection<FlowNode> flowNodes) {
        return flowNodes.stream().filter(this::isExecutable).collect(Collectors.toSet());
    }

    private boolean isExecutable(ModelElementInstance node) {
        if (node == null) {
            return false;
        }
        if (node instanceof Process) {
            return ((Process)node).isExecutable();
        }
        return this.isExecutable(node.getParentElement());
    }

    private Set<SequenceFlow> getExecutableSequenceNodes(Collection<SequenceFlow> sequenceFlows) {
        return sequenceFlows.stream().filter(s -> this.definitionFlowNodes.contains(s.getSource())).collect(Collectors.toSet());
    }

    public void addCoveredElement(CoveredElement element) {
        if (element instanceof CoveredFlowNode) {
            this.coveredFlowNodes.add((CoveredFlowNode)element);
        } else if (element instanceof CoveredSequenceFlow) {
            this.coveredSequenceFlows.add((CoveredSequenceFlow)element);
        } else {
            logger.log(Level.SEVERE, "Attempted adding unsupported element to process coverage. Process definition ID: {0} Element ID: {1}", new Object[]{element.getProcessDefinitionKey(), element.getElementId()});
        }
    }

    public void endCoveredElement(CoveredElement element) {
        if (element instanceof CoveredFlowNode) {
            CoveredFlowNode endedFlowNode = (CoveredFlowNode)element;
            this.coveredFlowNodes.stream().filter(obj -> obj.getFlowNodeInstanceId().equals(endedFlowNode.getFlowNodeInstanceId())).findFirst().get().setExecutionEndCoutner(endedFlowNode.getExecutionEndCoutner());
        } else {
            logger.log(Level.SEVERE, "Attempted ending unsupported element to process coverage. Process definition ID: {0} Element ID: {1}", new Object[]{element.getProcessDefinitionKey(), element.getElementId()});
        }
    }

    public List<String> getCoveredFlowNodeIds() {
        return this.coveredFlowNodes.stream().map(CoveredFlowNode::getElementId).collect(Collectors.toList());
    }

    public List<String> getCoveredSequenceFlowIds() {
        return this.coveredSequenceFlows.stream().map(CoveredSequenceFlow::getElementId).collect(Collectors.toList());
    }

    public String toString() {
        return "ProcessCoverage(processDefinition=" + this.getProcessDefinition() + ", coveredFlowNodes=" + this.getCoveredFlowNodes() + ", definitionFlowNodes=" + this.getDefinitionFlowNodes() + ", coveredSequenceFlows=" + this.getCoveredSequenceFlows() + ", definitionSequenceFlows=" + this.getDefinitionSequenceFlows() + ")";
    }

    public ProcessDefinition getProcessDefinition() {
        return this.processDefinition;
    }

    public List<CoveredFlowNode> getCoveredFlowNodes() {
        return this.coveredFlowNodes;
    }

    public Set<FlowNode> getDefinitionFlowNodes() {
        return this.definitionFlowNodes;
    }

    public List<CoveredSequenceFlow> getCoveredSequenceFlows() {
        return this.coveredSequenceFlows;
    }

    public Set<SequenceFlow> getDefinitionSequenceFlows() {
        return this.definitionSequenceFlows;
    }
}

