/*
 * Decompiled with CFR 0.152.
 */
package io.flowcov.camunda.junit;

import io.flowcov.camunda.model.ClassCoverage;
import io.flowcov.camunda.model.CoveredDmnRule;
import io.flowcov.camunda.model.CoveredElement;
import io.flowcov.camunda.model.CoveredFlowNode;
import io.flowcov.camunda.model.DecisionCoverage;
import io.flowcov.camunda.model.MethodCoverage;
import io.flowcov.camunda.model.ProcessCoverage;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;

public class FlowCovTestRunState {
    private Logger log = Logger.getLogger(FlowCovTestRunState.class.getCanonicalName());
    private ClassCoverage classCoverage = new ClassCoverage();
    private String testClassName;
    private Integer executionCounter = 0;
    private String currentTestMethodName;
    private List<String> excludedProcessDefinitionKeys;

    public void addCoveredElement(CoveredElement coveredElement) {
        Integer n = this.executionCounter;
        Integer n2 = this.executionCounter = Integer.valueOf(this.executionCounter + 1);
        coveredElement.setExecutionStartCounter(this.executionCounter);
        if (!this.isExcluded(coveredElement)) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.info("addCoveredElement(" + coveredElement + ")");
            }
            this.classCoverage.addCoveredElement(this.currentTestMethodName, coveredElement);
        }
    }

    public void endCoveredElement(CoveredElement coveredElement) {
        Integer n = this.executionCounter;
        Integer n2 = this.executionCounter = Integer.valueOf(this.executionCounter + 1);
        if (coveredElement instanceof CoveredFlowNode) {
            CoveredFlowNode endedFlowNode = (CoveredFlowNode)coveredElement;
            endedFlowNode.setExecutionEndCoutner(this.executionCounter);
        }
        if (!this.isExcluded(coveredElement)) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.info("endCoveredElement(" + coveredElement + ")");
            }
            this.classCoverage.endCoveredElement(this.currentTestMethodName, coveredElement);
        }
    }

    public void addCoveredRules(List<CoveredDmnRule> coveredDmnRule) {
        this.classCoverage.addCoveredDmnRules(this.currentTestMethodName, coveredDmnRule);
    }

    public void initializeTestMethodCoverage(ProcessEngine processEngine, String deploymentId, List<ProcessDefinition> processDefinitions, List<DecisionDefinition> decisionDefinitions, String testName) {
        MethodCoverage testCoverage = new MethodCoverage(deploymentId, testName);
        processDefinitions.stream().map(obj -> new ProcessCoverage(processEngine, (ProcessDefinition)obj)).forEach(testCoverage::addProcessCoverage);
        decisionDefinitions.stream().map(obj -> new DecisionCoverage(processEngine, (DecisionDefinition)obj)).forEach(testCoverage::addDecisionCoverage);
        this.classCoverage.addTestMethodCoverage(testName, testCoverage);
    }

    public MethodCoverage getTestMethodCoverage(String testName) {
        return this.classCoverage.getTestMethodCoverage(testName);
    }

    public MethodCoverage getCurrentTestMethodCoverage() {
        return this.classCoverage.getTestMethodCoverage(this.currentTestMethodName);
    }

    public ClassCoverage getClassCoverage() {
        return this.classCoverage;
    }

    public String getCurrentTestMethodName() {
        return this.currentTestMethodName;
    }

    public void setCurrentTestMethodName(String currentTestName) {
        this.currentTestMethodName = currentTestName;
    }

    public String getTestClassName() {
        return this.testClassName;
    }

    public void setTestClassName(String className) {
        this.testClassName = className;
    }

    public void setExcludedProcessDefinitionKeys(List<String> excludedProcessDefinitionKeys) {
        this.excludedProcessDefinitionKeys = excludedProcessDefinitionKeys;
    }

    private boolean isExcluded(CoveredElement coveredElement) {
        if (this.excludedProcessDefinitionKeys != null) {
            return this.excludedProcessDefinitionKeys.contains(coveredElement.getProcessDefinitionKey());
        }
        return false;
    }
}

