/*
 * Decompiled with CFR 0.152.
 */
package io.flowcov.camunda.listeners;

import io.flowcov.camunda.junit.FlowCovTestRunState;
import io.flowcov.camunda.model.CoveredFlowNode;
import io.flowcov.camunda.model.CoveredSequenceFlow;
import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.DelegateListener;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.impl.bpmn.parser.AbstractBpmnParseListener;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.process.TransitionImpl;
import org.camunda.bpm.engine.impl.util.xml.Element;

public class ElementCoverageParseListener
extends AbstractBpmnParseListener {
    private FlowCovTestRunState coverageTestRunState;
    private static final List<String> EXECUTION_EVENTS = Arrays.asList("start", "end");
    private final ExecutionListener executionListener = this::execute;

    private void execute(DelegateExecution execution) {
        CoveredFlowNode coveredActivity;
        if ("start".equals(execution.getEventName())) {
            coveredActivity = this.createCoveredFlowNode(execution);
            this.coverageTestRunState.addCoveredElement(coveredActivity);
        }
        if ("end".equals(execution.getEventName())) {
            coveredActivity = this.createCoveredFlowNode(execution);
            this.coverageTestRunState.endCoveredElement(coveredActivity);
        }
        if ("take".equals(execution.getEventName())) {
            CoveredSequenceFlow coveredSequenceFlow = new CoveredSequenceFlow(this.getProcessKey(execution), execution.getCurrentTransitionId());
            this.coverageTestRunState.addCoveredElement(coveredSequenceFlow);
        }
    }

    private CoveredFlowNode createCoveredFlowNode(DelegateExecution execution) {
        return new CoveredFlowNode(this.getProcessKey(execution), execution.getBpmnModelElementInstance().getId(), execution.getActivityInstanceId(), execution.getBpmnModelElementInstance().getElementType().getTypeName());
    }

    private String getProcessKey(DelegateExecution delegateExecution) {
        return delegateExecution.getProcessEngineServices().getRepositoryService().getProcessDefinition(delegateExecution.getProcessDefinitionId()).getKey();
    }

    public void parseUserTask(Element userTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseBoundaryErrorEventDefinition(Element errorEventDefinition, boolean interrupting, ActivityImpl activity, ActivityImpl nestedErrorEventActivity) {
    }

    public void parseBoundaryEvent(Element boundaryEventElement, ScopeImpl scopeElement, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseBoundaryMessageEventDefinition(Element element, boolean interrupting, ActivityImpl activity) {
    }

    public void parseBoundarySignalEventDefinition(Element signalEventDefinition, boolean interrupting, ActivityImpl activity) {
    }

    public void parseBoundaryTimerEventDefinition(Element timerEventDefinition, boolean interrupting, ActivityImpl activity) {
    }

    public void parseBusinessRuleTask(Element businessRuleTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseCallActivity(Element callActivityElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseCompensateEventDefinition(Element compensateEventDefinition, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseEndEvent(Element endEventElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseEventBasedGateway(Element eventBasedGwElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseExclusiveGateway(Element exclusiveGwElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseInclusiveGateway(Element inclusiveGwElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseIntermediateCatchEvent(Element intermediateEventElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseIntermediateMessageCatchEventDefinition(Element messageEventDefinition, ActivityImpl activity) {
    }

    public void parseIntermediateSignalCatchEventDefinition(Element signalEventDefinition, ActivityImpl activity) {
    }

    public void parseIntermediateThrowEvent(Element intermediateEventElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseIntermediateTimerEventDefinition(Element timerEventDefinition, ActivityImpl activity) {
    }

    public void parseManualTask(Element manualTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseMultiInstanceLoopCharacteristics(Element activityElement, Element multiInstanceLoopCharacteristicsElement, ActivityImpl activity) {
    }

    public void parseParallelGateway(Element parallelGwElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseReceiveTask(Element receiveTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseScriptTask(Element scriptTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseSendTask(Element sendTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseSequenceFlow(Element sequenceFlowElement, ScopeImpl scopeElement, TransitionImpl transition) {
        this.addExecutionListener(transition);
    }

    public void parseServiceTask(Element serviceTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseStartEvent(Element startEventElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseSubProcess(Element subProcessElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseTask(Element taskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseTransaction(Element transactionElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    private void addExecutionListener(ActivityImpl activity) {
        for (String event : EXECUTION_EVENTS) {
            activity.addListener(event, (DelegateListener)this.executionListener);
        }
    }

    private void addExecutionListener(TransitionImpl transition) {
        transition.addListener("take", (DelegateListener)this.executionListener);
    }

    public void setCoverageTestRunState(FlowCovTestRunState coverageTestRunState) {
        this.coverageTestRunState = coverageTestRunState;
    }
}

