/*
 * Decompiled with CFR 0.152.
 */
package io.flowcov.camunda.model;

import io.flowcov.camunda.model.AggregatedCoverage;
import io.flowcov.camunda.model.CoveredDmnRule;
import io.flowcov.camunda.model.CoveredElement;
import io.flowcov.camunda.model.CoveredFlowNode;
import io.flowcov.camunda.model.CoveredSequenceFlow;
import io.flowcov.camunda.model.MethodCoverage;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.junit.Assert;

public class ClassCoverage
implements AggregatedCoverage {
    private Map<String, MethodCoverage> testNameToMethodCoverage = new HashMap<String, MethodCoverage>();

    public void addCoveredElement(String testName, CoveredElement coveredElement) {
        this.testNameToMethodCoverage.get(testName).addCoveredElement(coveredElement);
    }

    public void endCoveredElement(String currentTestMethodName, CoveredElement coveredElement) {
        this.testNameToMethodCoverage.get(currentTestMethodName).endCoveredElement(coveredElement);
    }

    public void addCoveredDmnRules(String currentTestMethodName, List<CoveredDmnRule> coveredDmnRules) {
        this.testNameToMethodCoverage.get(currentTestMethodName).addCoveredDmnRules(coveredDmnRules);
    }

    public MethodCoverage getTestMethodCoverage(String testName) {
        return this.testNameToMethodCoverage.get(testName);
    }

    public Map<String, MethodCoverage> getTestMethodCoverage() {
        return this.testNameToMethodCoverage;
    }

    public void addTestMethodCoverage(String testName, MethodCoverage testCoverage) {
        this.testNameToMethodCoverage.put(testName, testCoverage);
    }

    @Override
    public List<CoveredFlowNode> getCoveredFlowNodes(String processDefinitionKey) {
        return this.testNameToMethodCoverage.values().stream().map(obj -> obj.getCoveredFlowNodes(processDefinitionKey)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public List<CoveredSequenceFlow> getCoveredSequenceFlows(String processDefinitionKey) {
        return this.testNameToMethodCoverage.values().stream().map(obj -> obj.getCoveredSequenceFlows(processDefinitionKey)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public Set<CoveredDmnRule> getCoveredDecisionRules(String decisionKey) {
        return this.testNameToMethodCoverage.values().stream().map(obj -> obj.getCoveredDecisionRules(decisionKey)).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    public Set<ProcessDefinition> getProcessDefinitions() {
        return this.getAnyMethodCoverage().getProcessDefinitions();
    }

    @Override
    public Set<DecisionDefinition> getDecisionDefinitions() {
        return this.getAnyMethodCoverage().getDecisionDefinitions();
    }

    protected MethodCoverage getAnyMethodCoverage() {
        MethodCoverage anyDeployment = this.testNameToMethodCoverage.values().iterator().next();
        return anyDeployment;
    }

    public void assertAllDeploymentsEqual() {
        Set<ProcessDefinition> processDefinitions = null;
        for (MethodCoverage methodCoverage : this.testNameToMethodCoverage.values()) {
            Set<ProcessDefinition> deploymentProcessDefinitions = methodCoverage.getProcessDefinitions();
            if (processDefinitions == null) {
                processDefinitions = deploymentProcessDefinitions;
            }
            Assert.assertEquals((String)"Class coverage can only be calculated if all tests deploy the same BPMN resources.", processDefinitions, deploymentProcessDefinitions);
        }
    }
}

