/*
 * Decompiled with CFR 0.152.
 */
package io.flowcov.camunda.util;

import io.flowcov.camunda.api.Build;
import io.flowcov.camunda.api.bpmn.BpmnModel;
import io.flowcov.camunda.api.bpmn.BpmnTestClass;
import io.flowcov.camunda.api.bpmn.BpmnTestMethod;
import io.flowcov.camunda.api.bpmn.FlowNode;
import io.flowcov.camunda.api.bpmn.SequenceFlow;
import io.flowcov.camunda.api.dmn.DmnModel;
import io.flowcov.camunda.api.dmn.DmnTestClass;
import io.flowcov.camunda.api.dmn.DmnTestMethod;
import io.flowcov.camunda.api.dmn.Rule;
import io.flowcov.camunda.junit.FlowCovTestRunState;
import io.flowcov.camunda.model.ClassCoverage;
import io.flowcov.camunda.util.FlowCovReporter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;

public class CoverageReportUtil {
    private static final Logger logger = Logger.getLogger(CoverageReportUtil.class.getCanonicalName());
    public static final String TARGET_DIR_ROOT = "target/flowcov/";

    public static void createClassReport(ProcessEngine processEngine, FlowCovTestRunState coverageTestRunState) {
        ClassCoverage coverage = coverageTestRunState.getClassCoverage();
        String reportDirectory = CoverageReportUtil.getReportDirectoryPath();
        CoverageReportUtil.createReport(coverage, reportDirectory, coverageTestRunState.getTestClassName());
    }

    private static void createReport(ClassCoverage coverage, String reportDirectory, String testClazz) {
        try {
            Build build = new Build();
            for (ProcessDefinition processDefinition : coverage.getProcessDefinitions()) {
                build.getBpmnModels().add(CoverageReportUtil.parseProcessDefinition(coverage, testClazz, processDefinition));
            }
            for (DecisionDefinition decisionDefinition : coverage.getDecisionDefinitions()) {
                build.getDmnModels().add(CoverageReportUtil.parseDecisionDefinition(coverage, testClazz, decisionDefinition));
            }
            FlowCovReporter.generateReport(reportDirectory + "/" + testClazz + "/flowCovReport.json", build);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Unable to load process definition!", ex);
            throw new RuntimeException();
        }
    }

    private static BpmnModel parseProcessDefinition(ClassCoverage coverage, String testClazz, ProcessDefinition processDefinition) throws IOException {
        String bpmnXml = CoverageReportUtil.getBpmnXml(processDefinition);
        BpmnModel model = BpmnModel.builder().bpmnXml(bpmnXml).processDefinitionKey(processDefinition.getKey()).name(processDefinition.getName()).version(processDefinition.getVersionTag()).hash(bpmnXml.hashCode()).build();
        List<BpmnTestMethod> testMethods = coverage.getTestMethodCoverage().values().stream().filter(m -> m.getName() != null).map(value -> {
            model.setTotalNodeCount(value.getProcessElementCount(processDefinition.getKey()));
            List<FlowNode> coveredFlowNodes = value.getCoveredFlowNodes(processDefinition.getKey()).stream().map(node -> FlowNode.builder().executionStartCounter(node.getExecutionStartCounter()).executionEndCounter(node.getExecutionEndCoutner()).key(node.getElementId()).type(node.getType()).build()).collect(Collectors.toList());
            List<SequenceFlow> coveredSequenceFlowIds = value.getCoveredSequenceFlows(processDefinition.getKey()).stream().map(obj -> SequenceFlow.builder().key(obj.getTransitionId()).executionStartCounter(obj.getExecutionStartCounter().intValue()).build()).collect(Collectors.toList());
            return BpmnTestMethod.builder().flowNodes(coveredFlowNodes).sequenceFlows(coveredSequenceFlowIds).name(value.getName()).build();
        }).collect(Collectors.toList());
        BpmnTestClass testClass = BpmnTestClass.builder().name(testClazz).testMethods(testMethods).build();
        model.getTestClasses().add(testClass);
        return model;
    }

    private static DmnModel parseDecisionDefinition(ClassCoverage coverage, String testClazz, DecisionDefinition decisionDefinition) throws IOException {
        String bpmnXml = CoverageReportUtil.getDmnXml(decisionDefinition);
        DmnModel model = DmnModel.builder().dmnXml(bpmnXml).decisionKey(decisionDefinition.getKey()).name(decisionDefinition.getName()).version(decisionDefinition.getVersionTag()).hash(bpmnXml.hashCode()).build();
        List<DmnTestMethod> testMethods = coverage.getTestMethodCoverage().values().stream().filter(m -> m.getName() != null).map(value -> {
            model.setRuleCount(value.getDecisionRuleCount(decisionDefinition.getKey()));
            List<Rule> coveredFlowNodes = value.getCoveredDecisionRules(decisionDefinition.getKey()).stream().map(rule -> Rule.builder().key(rule.getRuleId()).build()).collect(Collectors.toList());
            return DmnTestMethod.builder().rules(coveredFlowNodes).name(value.getName()).build();
        }).collect(Collectors.toList());
        DmnTestClass testClass = DmnTestClass.builder().name(testClazz).executionEndTime(LocalDateTime.now()).testMethods(testMethods).build();
        model.getTestClasses().add(testClass);
        return model;
    }

    private static String getReportDirectoryPath() {
        return TARGET_DIR_ROOT;
    }

    protected static String getBpmnXml(ProcessDefinition processDefinition) throws IOException {
        InputStream inputStream = CoverageReportUtil.class.getClassLoader().getResourceAsStream(processDefinition.getResourceName());
        if (inputStream == null) {
            inputStream = new FileInputStream(processDefinition.getResourceName());
        }
        return IOUtils.toString((InputStream)inputStream);
    }

    protected static String getDmnXml(DecisionDefinition decisionDefinition) throws IOException {
        InputStream inputStream = CoverageReportUtil.class.getClassLoader().getResourceAsStream(decisionDefinition.getResourceName());
        if (inputStream == null) {
            inputStream = new FileInputStream(decisionDefinition.getResourceName());
        }
        return IOUtils.toString((InputStream)inputStream);
    }
}

